/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.binedit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

abstract class Command
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Command.class.getName());
    protected final int offset;
    protected final int length;

    public Command(int n, int n2) {
        this.offset = n;
        this.length = n2;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public abstract int exec(byte[] var1, int var2);

    public abstract int undo(byte[] var1, int var2);

    protected static final void insert(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n2, byArray, n2 + n3, n - n2);
        Arrays.fill(byArray, n2, n2 + n3, (byte)0);
    }

    protected static final void delete(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n2 + n3, byArray, n2, n - n2 - n3);
        Arrays.fill(byArray, n - n3, n, (byte)-1);
    }

    public static class Complex
    extends Command {
        private static final long serialVersionUID = 1L;
        private final List<Command> command = new ArrayList<Command>();

        public Complex() {
            super(0, 1);
        }

        public void add(Command command) {
            this.command.add(command);
        }

        public int getOffset() {
            int n = this.command.get(0).getOffset();
            for (Command command : this.command) {
                n = Math.min(n, command.getOffset());
            }
            return n;
        }

        public int getLength() {
            int n = this.command.get(0).getOffset();
            for (Command command : this.command) {
                n = Math.max(n, command.getOffset() + command.getLength());
            }
            return n - this.getOffset();
        }

        public int exec(byte[] byArray, int n) {
            for (int i = 0; i < this.command.size(); ++i) {
                n = this.command.get(i).exec(byArray, n);
            }
            return n;
        }

        public int undo(byte[] byArray, int n) {
            for (int i = 0; i < this.command.size(); ++i) {
                n = this.command.get(i).undo(byArray, n);
            }
            return n;
        }
    }

    public static class Delete
    extends Command {
        private static final long serialVersionUID = 1L;
        private final byte[] old;

        public Delete(int n, int n2) {
            super(n, n2);
            this.old = new byte[n2];
        }

        public int exec(byte[] byArray, int n) {
            logger.finer("delete execute: [" + this.offset + "]+" + this.length + " bytes");
            System.arraycopy(byArray, this.offset, this.old, 0, this.length);
            Delete.delete(byArray, n, this.offset, this.length);
            return n - this.length;
        }

        public int undo(byte[] byArray, int n) {
            logger.finer("delete undo: [" + this.offset + "]+" + this.length + " bytes");
            Delete.insert(byArray, n, this.offset, this.length);
            System.arraycopy(this.old, 0, byArray, this.offset, this.length);
            return n + this.length;
        }
    }

    public static class Insert
    extends Command {
        private static final long serialVersionUID = 1L;

        public Insert(int n, int n2) {
            super(n, n2);
        }

        public int exec(byte[] byArray, int n) {
            logger.finer("insert execute: [" + this.offset + "]+" + this.length + " bytes");
            Insert.insert(byArray, n, this.offset, this.length);
            return n + this.length;
        }

        public int undo(byte[] byArray, int n) {
            logger.finer("insert undo: [" + this.offset + "]+" + this.length + " bytes");
            Insert.delete(byArray, n, this.offset, this.length);
            return n - this.length;
        }
    }

    public static class Change
    extends Command {
        private static final long serialVersionUID = 1L;
        private final byte value;
        private byte old = (byte)-1;

        public Change(int n, byte by) {
            super(n, 1);
            this.value = by;
        }

        public int exec(byte[] byArray, int n) {
            logger.finer("change execute: [" + this.offset + "] = 0x" + String.format("%02X", this.value));
            this.old = byArray[this.offset];
            byArray[this.offset] = this.value;
            return n;
        }

        public int undo(byte[] byArray, int n) {
            logger.finer("change undo: [" + this.offset + "] = 0x" + String.format("%02X", this.old));
            byArray[this.offset] = this.old;
            return n;
        }
    }
}

