/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.binedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.text.JTextComponent;
import org.koiroha.binedit.HexModel;

public class BinaryEditor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(BinaryEditor.class.getName());
    private final JTable hexTable = new JTable(){
        private static final long serialVersionUID = 1L;

        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            Component component;
            boolean bl;
            if (eventObject instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)eventObject;
                if (keyEvent.getKeyCode() == 127 && keyEvent.getModifiers() == 0) {
                    return false;
                }
                if (keyEvent.getKeyCode() == 8 && keyEvent.getModifiers() == 0) {
                    return false;
                }
                if (keyEvent.getKeyCode() == 157 || keyEvent.getModifiers() == 4) {
                    return false;
                }
            }
            if ((bl = super.editCellAt(n, n2, eventObject)) && (component = super.getEditorComponent()) instanceof JTextComponent) {
                ((JTextComponent)component).selectAll();
            }
            return bl;
        }
    };
    private final HexModel model = new HexModel();
    private final JLabel dataSize = new JLabel();
    private final JLabel selectedIndex = new JLabel();
    private final JComboBox byteOrder = new JComboBox();
    private final JCheckBox fieldSign = new JCheckBox();
    private final JComboBox fieldType = new JComboBox();
    private final JTextField fieldValue = new JTextField(6);
    private final Preferences pref = Preferences.userNodeForPackage(BinaryEditor.class);
    private static final int META = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private final Action insert = new AbstractAction("\u633f\u5165"){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, META));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BinaryEditor.this.insert();
        }
    };
    private final Action delete = new AbstractAction("\u524a\u9664"){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BinaryEditor.this.delete();
        }
    };
    private final Action undo = new AbstractAction("\u3084\u308a\u76f4\u3057"){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, META));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BinaryEditor.this.model.undo();
            if (n >= 0) {
                BinaryEditor.this.hexTable.changeSelection(n / 16, n % 16 + 1, false, false);
            }
        }
    };
    private final Action redo = new AbstractAction("\u3084\u308a\u76f4\u3057\u306e\u3084\u308a\u76f4\u3057"){
        private static final long serialVersionUID = 1L;
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, META | 1));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BinaryEditor.this.model.redo();
            if (n >= 0) {
                BinaryEditor.this.hexTable.changeSelection(n / 16, n % 16 + 1, false, false);
            }
        }
    };

    public BinaryEditor() {
        this.setTitle("\u30d0\u30a4\u30ca\u30ea\u30a8\u30c7\u30a3\u30bf");
        this.setJMenuBar(this.createMenuBar());
        this.getContentPane().setLayout(new BorderLayout());
        this.hexTable.setModel(this.model);
        this.hexTable.setDefaultRenderer(Object.class, new HexModel.Renderer());
        this.hexTable.setFont(new Font("monospaced", 0, 14));
        this.hexTable.setCellSelectionEnabled(true);
        this.hexTable.setAutoResizeMode(0);
        this.hexTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.hexTable.setShowVerticalLines(false);
        this.hexTable.setShowHorizontalLines(false);
        this.hexTable.setShowGrid(false);
        for (int i = 0; i < 16; ++i) {
            this.hexTable.getColumnModel().getColumn(i + 1).setPreferredWidth(30);
        }
        this.hexTable.getColumnModel().getColumn(17).setPreferredWidth(150);
        this.hexTable.setIntercellSpacing(new Dimension(0, 0));
        this.getContentPane().add("Center", new JScrollPane(this.hexTable));
        this.hexTable.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 8 && keyEvent.getModifiers() == 0) {
                    BinaryEditor.this.backspace();
                    return;
                }
                if (keyEvent.getKeyCode() == 37 && keyEvent.getModifiers() == 0) {
                    int n = BinaryEditor.this.hexTable.getSelectedRow();
                    int n2 = BinaryEditor.this.hexTable.getSelectedColumn();
                    if (n >= 0 && n2 == 1) {
                        if (n > 0) {
                            BinaryEditor.this.hexTable.changeSelection(n - 1, 17, false, false);
                        } else {
                            BinaryEditor.this.hexTable.changeSelection(BinaryEditor.this.hexTable.getRowCount() - 1, 17, false, false);
                        }
                    }
                    return;
                }
                if (keyEvent.getKeyCode() == 39 && keyEvent.getModifiers() == 0) {
                    int n = BinaryEditor.this.hexTable.getSelectedRow();
                    int n3 = BinaryEditor.this.hexTable.getSelectedColumn();
                    if (n >= 0 && n3 == 16) {
                        if (n < BinaryEditor.this.hexTable.getRowCount()) {
                            BinaryEditor.this.hexTable.changeSelection(n + 1, 0, false, false);
                        } else {
                            BinaryEditor.this.hexTable.changeSelection(0, 0, false, false);
                        }
                    }
                    return;
                }
            }
        });
        this.hexTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BinaryEditor.this.onSelectedCellChanged();
            }
        });
        this.hexTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                BinaryEditor.this.onSelectedCellChanged();
            }
        });
        this.getContentPane().add("South", this.createStatusBar());
        this.setSize(new Dimension(800, 480));
        this.setLocation(40, 40);
        this.model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BinaryEditor.this.update();
            }
        });
        this.update();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BinaryEditor.this.exit();
            }
        });
        this.setDefaultCloseOperation(0);
    }

    private JMenuBar createMenuBar() {
        final int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("\u30d5\u30a1\u30a4\u30eb");
        jMenuBar.add(jMenu);
        jMenu.add(new AbstractAction("\u958b\u304f"){
            private static final long serialVersionUID = 1L;
            {
                super(string);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, n));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BinaryEditor.this.open();
            }
        });
        jMenu.add(new AbstractAction("\u4fdd\u5b58"){
            private static final long serialVersionUID = 1L;
            {
                super(string);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, n));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BinaryEditor.this.save();
            }
        });
        jMenu.add(new AbstractAction("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58"){
            private static final long serialVersionUID = 1L;
            {
                super(string);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, n | 0x40));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                BinaryEditor.this.saveAs();
            }
        });
        jMenu.addSeparator();
        jMenu.add(new AbstractAction("\u7d42\u4e86"){
            private static final long serialVersionUID = 1L;
            {
                super(string);
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, n));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (BinaryEditor.this.exit()) {
                    BinaryEditor.this.dispose();
                }
            }
        });
        JMenu jMenu2 = new JMenu("\u7de8\u96c6");
        jMenuBar.add(jMenu2);
        jMenu2.add(this.insert);
        jMenu2.add(this.delete);
        jMenu2.addSeparator();
        jMenu2.add(this.undo);
        jMenu2.add(this.redo);
        return jMenuBar;
    }

    private JPanel createStatusBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.byteOrder.addItem(ByteOrder.LITTLE_ENDIAN);
        this.byteOrder.addItem(ByteOrder.BIG_ENDIAN);
        this.byteOrder.setSelectedItem(ByteOrder.nativeOrder());
        this.byteOrder.setMaximumSize(new Dimension(Integer.MAX_VALUE, 200));
        BinaryEditor.layout(jPanel, this.byteOrder, 0, 0, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0);
        this.fieldSign.setText("\u00b1");
        BinaryEditor.layout(jPanel, this.fieldSign, 1, 0, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0);
        this.fieldType.addItem(FieldType.BYTE);
        this.fieldType.addItem(FieldType.SHORT);
        this.fieldType.addItem(FieldType.INT);
        this.fieldType.addItem(FieldType.LONG);
        this.fieldType.addItem(FieldType.LLONG);
        this.fieldType.addItem(FieldType.FLOAT);
        this.fieldType.addItem(FieldType.DOUBLE);
        this.fieldValue.setHorizontalAlignment(4);
        BinaryEditor.layout(jPanel, this.fieldType, 2, 0, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0);
        this.fieldValue.setColumns(String.valueOf(Long.MAX_VALUE).length());
        BinaryEditor.layout(jPanel, this.fieldValue, 3, 0, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0);
        BinaryEditor.layout(jPanel, new JSeparator(1), 4, 0, 1, 1, 13, 0, 1.0, 0.0, 0, 0, 0, 0, 0, 0);
        BinaryEditor.layout(jPanel, this.selectedIndex, 5, 0, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 0);
        BinaryEditor.layout(jPanel, this.dataSize, 6, 0, 1, 1, 17, 0, 0.0, 0.0, 0, 0, 0, 0, 0, 5);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BinaryEditor.this.resetField(BinaryEditor.this.getSelectedIndex());
            }
        };
        this.byteOrder.addItemListener(itemListener);
        this.fieldType.addItemListener(itemListener);
        this.fieldSign.addItemListener(itemListener);
        return jPanel;
    }

    private void open() {
        String string = this.pref.get("dir.recent", ".");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(string));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        this.pref.put("dir.recent", file.getParent());
        try {
            this.model.open(file);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "\u30a8\u30e9\u30fc", 0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            long l = file.length() / 1024L / 1024L;
            String string2 = "\u30d5\u30a1\u30a4\u30eb\u304c\u5927\u304d\u3059\u304e\u3066\u958b\u3051\u307e\u305b\u3093\u3067\u3057\u305f (" + l + "MB)";
            if (l < 1536L) {
                string2 = string2 + "\nJava VM \u306b\u5272\u308a\u5f53\u3066\u308b\u30d2\u30fc\u30d7\u30b5\u30a4\u30ba\u3092\u5897\u3084\u3059\u4e8b\u3067\u958b\u3051\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059";
            }
            logger.log(Level.WARNING, string2);
            logger.log(Level.WARNING, file.toString(), outOfMemoryError);
            JOptionPane.showMessageDialog(this, string2, "\u30a8\u30e9\u30fc", 0);
        }
    }

    private boolean save() {
        if (this.model.getFile() == null) {
            return this.saveAs();
        }
        try {
            this.model.save(this.model.getFile());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "\u30a8\u30e9\u30fc", 0);
        }
        return true;
    }

    private boolean saveAs() {
        String string = this.pref.get("dir.recent", ".");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(string));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return false;
        }
        File file = jFileChooser.getSelectedFile();
        this.pref.put("dir.recent", file.getParent());
        try {
            this.model.save(file);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "\u30a8\u30e9\u30fc", 0);
        }
        return true;
    }

    private boolean exit() {
        int n;
        try {
            this.pref.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        if (this.model.isModified() && ((n = JOptionPane.showConfirmDialog(this, "\u30c7\u30fc\u30bf\u304c\u5909\u66f4\u3055\u308c\u3066\u304b\u3089\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093\n\u4fdd\u5b58\u3057\u307e\u3059\u304b?", "\u4fdd\u5b58\u306e\u78ba\u8a8d", 1, 2)) == 0 ? !this.save() : n == 2)) {
            return false;
        }
        this.setDefaultCloseOperation(3);
        return true;
    }

    private void backspace() {
        if (this.hexTable.isEditing()) {
            return;
        }
        int n = this.hexTable.getSelectedRow();
        int n2 = this.hexTable.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        int n3 = this.model.getIndex(n, n2);
        if (n3 > 0) {
            this.model.delete(n3 - 1);
            if (n2 == 1) {
                this.hexTable.changeSelection(n - 1, 16, false, false);
            } else {
                this.hexTable.changeSelection(n, n2 - 1, false, false);
            }
        }
    }

    private void delete() {
        int n;
        if (this.hexTable.isEditing()) {
            return;
        }
        int[] nArray = this.hexTable.getSelectedRows();
        int[] nArray2 = this.hexTable.getSelectedColumns();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; nArray != null && i < nArray.length; ++i) {
            for (n = 0; nArray2 != null && n < nArray2.length; ++n) {
                int n2 = this.model.getIndex(nArray[i], nArray2[n]);
                if (n2 < 0 || n2 >= this.model.getLength()) continue;
                arrayList.add(n2);
            }
        }
        int[] nArray3 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray3[n] = (Integer)arrayList.get(n);
        }
        this.model.delete(nArray3);
    }

    private void insert() {
        int n = this.hexTable.getSelectedRow();
        int n2 = this.hexTable.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        int n3 = this.model.getIndex(n, n2);
        if (n3 >= 0) {
            this.model.insert(n3);
        }
    }

    private int getSelectedIndex() {
        int n = this.hexTable.getSelectedRow();
        int n2 = this.hexTable.getSelectedColumn();
        int n3 = -1;
        if (n >= 0 && n2 >= 0) {
            n3 = this.model.getIndex(n, n2);
        }
        return n3;
    }

    private void onSelectedCellChanged() {
        int n = this.getSelectedIndex();
        this.insert.setEnabled(n >= 0);
        this.delete.setEnabled(n >= 0);
        if (n < 0) {
            this.selectedIndex.setVisible(false);
        } else {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            this.selectedIndex.setText(numberFormat.format(n) + "B/");
            if (!this.selectedIndex.isVisible()) {
                this.selectedIndex.setVisible(true);
            }
        }
        this.resetField(n);
    }

    private void update() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        this.dataSize.setText(numberFormat.format(this.model.getLength()) + "B");
        if (this.model.getFile() == null) {
            this.setTitle("Binary Editor");
        } else {
            this.setTitle("Binary Editor - " + this.model.getFile().getName() + (this.model.isModified() ? "*" : ""));
        }
    }

    private void resetField(int n) {
        FieldType fieldType = (FieldType)((Object)this.fieldType.getSelectedItem());
        if (fieldType.isReal()) {
            this.fieldSign.setEnabled(false);
        } else {
            this.fieldSign.setEnabled(true);
        }
        if (n < 0) {
            this.fieldValue.setText("");
            return;
        }
        ByteOrder byteOrder = (ByteOrder)this.byteOrder.getSelectedItem();
        boolean bl = this.fieldSign.isSelected();
        String string = null;
        ByteBuffer byteBuffer = this.model.getByteBuffer(n, fieldType.length(), byteOrder);
        if (byteBuffer == null) {
            string = "";
        } else if (fieldType.isReal()) {
            DecimalFormat decimalFormat = new DecimalFormat("0.########################E0");
            string = fieldType.length() == 4 ? decimalFormat.format(byteBuffer.getFloat()) : decimalFormat.format(byteBuffer.getDouble());
        } else {
            byte[] byArray = new byte[fieldType.length() + (bl ? 0 : 1)];
            byteBuffer.get(byArray, bl ? 0 : 1, fieldType.length());
            if (byteOrder.equals(ByteOrder.LITTLE_ENDIAN)) {
                int n2;
                int n3 = n2 = bl ? 0 : 1;
                while (n2 < byArray.length / 2) {
                    byte by = byArray[n2];
                    byArray[n2] = byArray[byArray.length - n2 - 1];
                    byArray[byArray.length - n2 - 1] = by;
                    ++n2;
                }
            }
            BigInteger bigInteger = new BigInteger(byArray);
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            string = numberFormat.format(bigInteger);
        }
        this.fieldValue.setText(string);
    }

    protected static void layout(Container container, Component component, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10, int n11, int n12) {
        assert (container.getLayout() instanceof GridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        gridBagConstraints.insets = new Insets(n9, n10, n11, n12);
        container.add(component, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("--debug") && !stringArray[i].equals("-d") && !stringArray[i].equals("--verbose") && !stringArray[i].equals("-v")) continue;
            BinaryEditor.setDebugLogging();
        }
        BinaryEditor binaryEditor = new BinaryEditor();
        binaryEditor.setVisible(true);
    }

    private static void setDebugLogging() {
        Logger logger = Logger.getLogger("org.koiroha.binedit");
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        logger.addHandler(consoleHandler);
        consoleHandler.setLevel(Level.ALL);
        logger.setLevel(Level.ALL);
        consoleHandler.setFormatter(new DebugFormatter());
    }

    private static class DebugFormatter
    extends Formatter {
        private DebugFormatter() {
        }

        public String format(LogRecord logRecord) {
            StringBuilder stringBuilder = new StringBuilder();
            Date date = new Date(logRecord.getMillis());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            stringBuilder.append('[').append(simpleDateFormat.format(date)).append(']').append(' ');
            stringBuilder.append(logRecord.getLevel().getName()).append(' ');
            String string = logRecord.getLoggerName();
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                string = string.substring(n + 1);
            }
            if (string.length() > 15) {
                stringBuilder.append(string.substring(15));
            } else {
                int n2 = stringBuilder.length() + 15;
                stringBuilder.append(string);
                while (stringBuilder.length() < n2) {
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append(" - ").append(logRecord.getMessage()).append('\n');
            if (logRecord.getThrown() != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.flush();
                stringBuilder.append(stringWriter.toString());
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FieldType {
        BYTE("8bit", 1, false),
        SHORT("16bit", 2, false),
        INT("32bit", 4, false),
        LONG("64bit", 8, false),
        LLONG("128bit", 16, false),
        FLOAT("float", 4, true),
        DOUBLE("double", 8, true);

        private final String name;
        private final int length;
        private final boolean real;

        private FieldType(String string2, int n2, boolean bl) {
            this.name = string2;
            this.length = n2;
            this.real = bl;
        }

        public boolean isReal() {
            return this.real;
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return this.name;
        }
    }
}

