/*
 * Decompiled with CFR 0.152.
 */
package org.koiroha.httpsniffer;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.koiroha.httpsniffer.BypassInputStream;
import org.koiroha.httpsniffer.ChunkedInputStream;
import org.koiroha.httpsniffer.HttpProxyEvent;
import org.koiroha.httpsniffer.HttpProxyListener;
import org.koiroha.httpsniffer.Request;
import org.koiroha.httpsniffer.Response;

public class HttpProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Logger logger = Logger.getLogger(HttpProxy.class.getName());
    private final Date date = new Date();
    private Request request = null;
    private Response response = null;
    private State state = State.REQUEST;
    private List<HttpProxyListener> listener = new ArrayList<HttpProxyListener>();

    public Date getDate() {
        return this.date;
    }

    public State getState() {
        return this.state;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getServerName() {
        if (this.request == null || this.request.getUrl() == null) {
            return null;
        }
        return this.request.getUrl().getHost();
    }

    public int getServerPort() {
        if (this.request == null || this.request.getUrl() == null) {
            return 0;
        }
        URL uRL = this.request.getUrl();
        if (uRL.getPort() <= 0) {
            return uRL.getDefaultPort();
        }
        return uRL.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Socket socket) throws IOException, URISyntaxException {
        this.request = new Request();
        logger.entering(HttpProxy.class.getName(), "execute");
        PushbackInputStream pushbackInputStream = new PushbackInputStream(socket.getInputStream());
        String string = HttpProxy.readLine(pushbackInputStream);
        logger.finer("read request status: " + string);
        Pattern pattern = Pattern.compile("([^\\s]+)\\s+([^\\s]+)\\s+HTTP/(\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            logger.warning("invalid request status: " + string);
            this.request.write((string + "\r\n").getBytes("UTF-8"));
            this.request.readFrom(pushbackInputStream, -1L);
            return;
        }
        logger.fine(string);
        for (int i = 1; i < matcher.groupCount() + 1; ++i) {
            logger.finer("[" + i + "] " + matcher.group(i));
        }
        this.request.setMethod(matcher.group(1));
        this.request.setUrl(new URL(matcher.group(2)));
        this.request.setVersion("HTTP/" + matcher.group(3));
        this.fireProxyStateChanged();
        String string2 = this.getServerName();
        int n = this.getServerPort();
        logger.finer("connecting server: " + string2 + ":" + n);
        Socket socket2 = new Socket(string2, n);
        try {
            logger.finer("server connection success: " + socket2.getInetAddress() + ":" + socket2.getPort());
            Sender sender = new Sender(pushbackInputStream, socket2.getOutputStream());
            sender.start();
            Receiver receiver = new Receiver(new PushbackInputStream(socket2.getInputStream()), socket.getOutputStream());
            receiver.start();
            logger.finer("waiting request/response...");
            sender.join();
            receiver.join();
            logger.finer("fine");
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                socket2.close();
            }
            catch (IOException iOException) {}
            this.state = State.DISCONNECTED;
            this.fireProxyStateChanged();
        }
    }

    private void request(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        this.state = State.REQUEST;
        StringBuilder stringBuilder = new StringBuilder();
        HttpProxy.readHeader(pushbackInputStream, stringBuilder);
        this.request.createHeader(stringBuilder.toString());
        this.request.getHeader().replaceValue("Connection", "close");
        this.request.getHeader().removeAll("Keep-Alive");
        this.request.getHeader().removeAll("Proxy-Connection");
        logger.finer("read request hreader");
        logger.finest(this.request.getHeader().toString());
        this.state = State.REQUEST;
        String string = this.request.getMethod() + " " + this.request.getUrl().getFile() + " " + this.request.getVersion() + "\r\n" + this.request.getHeader().toString().replaceAll("\n", "\r\n") + "\r\n\r\n";
        outputStream.write(string.getBytes("UTF-8"));
        outputStream.flush();
        logger.finer("send request status and headers");
        logger.finest(string);
        this.state = State.REQUEST;
        long l = 0L;
        String string2 = this.request.getHeader().getValue("Content-Length");
        if (string2 != null) {
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                logger.warning("invalid content-length: " + string2);
            }
        }
        logger.finer("request content-length: " + l);
        if (l > 0L) {
            int n;
            this.state = State.REQUEST;
            byte[] byArray = new byte[1024];
            for (long i = l; i > 0L; i -= (long)n) {
                n = pushbackInputStream.read(byArray, 0, (int)Math.min((long)byArray.length, i));
                if (n < 0) {
                    throw new EOFException("eof detected at: " + (i - l) + "/" + l);
                }
                this.request.write(byArray, 0, n);
            }
        }
        logger.finer("read request content: " + this.request.getTransferContentSize() + " bytes");
        this.state = State.REQUEST;
        this.fireProxyStateChanged();
        this.request.writeTo(outputStream);
        outputStream.flush();
        logger.finer("send request content");
    }

    private void response(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        this.response = new Response();
        this.state = State.RESPONSE;
        String string = HttpProxy.readLine(pushbackInputStream);
        logger.fine("response status: " + string);
        Pattern pattern = Pattern.compile("HTTP/(\\d+\\.\\d+)\\s+(\\d+)\\s*(.*)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            logger.warning("invalid response status: " + string);
            this.response.write((string + "\r\n").getBytes());
            this.response.readFrom(pushbackInputStream, -1L);
            this.response.writeTo(outputStream);
            return;
        }
        for (int i = 1; i < matcher.groupCount() + 1; ++i) {
            logger.finer("[" + i + "] " + matcher.group(i));
        }
        this.response.setVersion("HTTP/" + matcher.group(1));
        this.response.setCode(Integer.parseInt(matcher.group(2)));
        this.response.setPhrase(matcher.group(3));
        this.state = State.RESPONSE;
        this.fireProxyStateChanged();
        this.state = State.RESPONSE;
        StringBuilder stringBuilder = new StringBuilder();
        HttpProxy.readHeader(pushbackInputStream, stringBuilder);
        this.response.createHeader(stringBuilder.toString());
        this.fireProxyStateChanged();
        logger.finer("read response header");
        logger.finest(this.response.getHeader().toString());
        this.state = State.RESPONSE;
        String string2 = this.response.getVersion() + " " + this.response.getCode() + " " + this.response.getPhrase() + "\r\n" + this.response.getHeader().toString().replaceAll("\n", "\r\n") + "\r\n\r\n";
        outputStream.write(string2.getBytes("UTF-8"));
        outputStream.flush();
        logger.finer("send response status and headers");
        logger.finest(string2);
        long l = -1L;
        String string3 = this.response.getHeader().getValue("Content-Length");
        try {
            if (string3 != null) {
                l = Long.parseLong(string3.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("invalid response content-length: " + string3);
        }
        pushbackInputStream = new PushbackInputStream(new BypassInputStream(pushbackInputStream, outputStream));
        String string4 = this.response.getHeader().getValue("Transfer-Encoding");
        if (string4 != null && string4.equalsIgnoreCase("chunked")) {
            pushbackInputStream = new PushbackInputStream(new ChunkedInputStream(pushbackInputStream));
            l = -1L;
        }
        this.state = State.RESPONSE;
        logger.finer("reading response content...: " + l + " bytes");
        this.response.readFrom(pushbackInputStream, l);
        logger.finer("read and send response content: " + this.response.getTransferContentSize() + " bytes");
        this.fireProxyStateChanged();
        outputStream.flush();
        logger.finer("send response content");
    }

    private static void readHeader(PushbackInputStream pushbackInputStream, StringBuilder stringBuilder) throws IOException {
        String string;
        while ((string = HttpProxy.readLine(pushbackInputStream)).length() != 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string);
        }
    }

    private static String readLine(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = pushbackInputStream.read()) >= 0 && n != 10) {
            if (n == 13) {
                n = pushbackInputStream.read();
                if (n == 10 || n < 0) break;
                pushbackInputStream.unread(n);
                break;
            }
            byteArrayOutputStream.write(n);
        }
        return new String(byteArrayOutputStream.toByteArray(), Charset.forName("UTF-8"));
    }

    public void addHttpProxyListener(HttpProxyListener httpProxyListener) {
        this.listener.add(httpProxyListener);
    }

    public void removeHttpProxyListener(HttpProxyListener httpProxyListener) {
        this.listener.remove(httpProxyListener);
    }

    private void fireProxyStateChanged() {
        HttpProxyEvent httpProxyEvent = new HttpProxyEvent(this);
        for (int i = 0; i < this.listener.size(); ++i) {
            this.listener.get(i).proxyStateChanged(httpProxyEvent);
        }
    }

    public static enum State {
        REQUEST,
        RESPONSE,
        DISCONNECTED;

    }

    private class Receiver
    extends Thread {
        private final PushbackInputStream in;
        private final OutputStream out;

        public Receiver(PushbackInputStream pushbackInputStream, OutputStream outputStream) {
            this.in = pushbackInputStream;
            this.out = outputStream;
        }

        @Override
        public void run() {
            try {
                HttpProxy.this.response(this.in, this.out);
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "response", exception);
            }
        }
    }

    private class Sender
    extends Thread {
        private final PushbackInputStream in;
        private final OutputStream out;

        public Sender(PushbackInputStream pushbackInputStream, OutputStream outputStream) {
            this.in = pushbackInputStream;
            this.out = outputStream;
        }

        @Override
        public void run() {
            try {
                HttpProxy.this.request(this.in, this.out);
            }
            catch (Exception exception) {
                logger.log(Level.INFO, "request", exception);
            }
        }
    }
}

