#ifndef _REGION_H
#define _REGION_H

enum kmemprof_objclass {
	SMALL_OBJ = 0,
	MEDIUM_OBJ,
	LARGE_OBJ,
	XLARGE_OBJ
};

struct bucket {
	struct {
		unsigned int address;
		unsigned int next;
	} chain;
	struct {
		struct {
			unsigned int count;
			unsigned int bytes;
		} per_objclass_amount[4];
	} per_evtype_amount[2];
};

struct region {
	unsigned int offset;
	unsigned int size;

	unsigned int * prof_table;
	unsigned int prof_len;
	unsigned int prof_shift;

	struct bucket * bucket;
	unsigned int bucket_len;
	unsigned int bucket_head;
	spinlock_t lock;
};

int region_create(struct region * region,
	unsigned int offset, unsigned int size, unsigned int shift);

void region_remove(struct region *region);

int region_populate_arc(struct region * region,
		enum kmemprof_event_type type, enum kmemprof_objclass class,
		unsigned int size, unsigned int from, unsigned int to);

#endif /* _REGION_H */

