/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITATHREAD_H
#define KITATHREAD_H

#include <qobject.h>
#include <qxml.h>
#include <qdict.h>

#include <stdio.h>

namespace KIO
{
    class Job;
};

class KURL;

namespace Kita
{
    /**
    @author Hideki Ikemoto
    */
    class Board;
    class BoardXmlParser;

    class Thread
    {
        Thread( const QString& datURL, const QString& threadName = QString::null );

    protected:
        Thread();

    public:
        ~Thread();

        const QString& datURL() const;
        const QString url() const;
        const QString datID() const;
        const QString& name() const;
        void setResNum( int resNum );
        int resNum() const;
        const QString& boardName() const;
        const QString boardURL() const;
        const QString boardID() const;

        const QString toXmlFragment() const;
        static Thread* fromXml( const QString& xml );

        static Thread* getByURL( const QString& datURL );
        static void setName( const QString& datURL, const QString& threadName );
    private:
        QString m_datURL;
        QString m_threadName;
        static QDict<Thread>* m_threadDict;
    };

    class NullThread : public Thread
    {
    public:
        NullThread();
        ~NullThread();
    };

    class ThreadXmlParser : public QXmlDefaultHandler
    {
    public:
        ThreadXmlParser();
        ~ThreadXmlParser() {};
        bool startElement( const QString& namespaceURI,
                           const QString& localName,
                           const QString& qName,
                           const QXmlAttributes& atts );
        bool endElement( const QString& namespaceURI,
                         const QString& localName,
                         const QString& qName );
        bool characters( const QString& ch );
        bool isValid() const { return m_isValid; }
        Thread* getThread() const { return m_thread; }

    private:
        QString m_datUrlStr;
        QString m_threadName;
        int m_resNum;
        Thread* m_thread;
        BoardXmlParser* m_boardParser;

        QString m_characters;

        bool m_inBoard;
        bool m_isValid;
        bool m_inThread;
    };
};

#endif
