/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef URLCONVERTTEST_H
#define URLCONVERTTEST_H

#include <cppunit/extensions/HelperMacros.h>
#include "../kita_misc.h"

/**
@author Hideki Ikemoto
*/
class URLConvertTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( URLConvertTest );
    CPPUNIT_TEST( testDatToThread );
    CPPUNIT_TEST( testThreadToDat );
    CPPUNIT_TEST( testBoardToSubject );
    CPPUNIT_TEST( testSubjectToBoard );
    CPPUNIT_TEST( testDatToCache );
    CPPUNIT_TEST( testDatToBoard );
    CPPUNIT_TEST( testHttpToK2ch );
    CPPUNIT_TEST_SUITE_END();

    QString m_datURL;
    QString m_datURL_k2ch;
    QString m_threadURL;
    QString m_threadURL_k2ch;
    QString m_threadURL2;
    QString m_threadURL2_k2ch;
    QString m_subjectURL;
    QString m_subjectURL_k2ch;
    QString m_boardURL;
    QString m_boardURL_k2ch;
    QString m_boardURL2;
    QString m_boardURL2_k2ch;
    QString m_cachePath;
    QString m_cachePath_k2ch;

public:
    void setUp();
    void tearDown();

    void testDatToThread();
    void testThreadToDat();
    void testBoardToSubject();
    void testSubjectToBoard();
    void testDatToCache();
    void testDatToBoard();
    void testHttpToK2ch();
};

#endif
