/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITAACCESS_H
#define KITAACCESS_H

#include <qobject.h>
#include <qcstring.h>

class KURL;

namespace KIO {
    class Job;
}

namespace Kita
{
    class Thread;

    /**
    @author Hideki Ikemoto
    */
    class Access : public QObject
    {
        Q_OBJECT

    public:
        Access( const Thread* thread ) : m_thread( thread ) {};
        ~Access() {};

        QString get();
        void killJob();
        int serverTime();

    private:
        void enter_loop();
        QString getCachePath( const KURL& url );
        QCString getCacheData( const KURL& url );
        void writeCacheData( const KURL& url );
        int responseCode();
        bool readCacheHeader( FILE* fs, const KURL& url );
        QString cacheDir( const KURL& url );
        QString cacheSubDir( const QString& host );
        QString hashString( const KURL& url );

        const Thread* m_thread;
        KIO::Job* m_currentJob;
        QCString m_threadData;
        QString m_header;
        QCString m_orgData;

    private slots:
        void slotReceiveThreadData( KIO::Job* job, const QByteArray& data );
        void slotRedirection( KIO::Job* job, const KURL& );
        void slotThreadResult( KIO::Job* job );

    signals:
        void redirection( const QString& );
    };

};

#endif
