/***************************************************************************
 *   Copyright (C) 2003 by Hideki Ikemoto                                  *
 *   ikemo@wakaba.jp                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// include files for Qt
#include <qtoolbutton.h>
#include <qtextbrowser.h>
#include <qtextcodec.h>
#include <qregexp.h>
#include <qfile.h>

// kdelibs/kio
#include <kio/slaveconfig.h>
#include <kio/netaccess.h>

// include files for KDE
#include <kfilterdev.h>
#include <klistview.h>
 
#include "kitasubjectview.h"
#include "kita.h"

KitaSubjectView::KitaSubjectView(QWidget *parent, const char *name)
  : KitaSubjectViewBase(parent, name)
{
  subjectList->addColumn("No");
  subjectList->addColumn("Title");
  subjectList->addColumn("ResNum");
  subjectList->addColumn("Dat");
  connect(subjectList, SIGNAL(clicked(QListViewItem*)), SLOT(loadThread(QListViewItem*)));
}


KitaSubjectView::~KitaSubjectView()
{
}

void KitaSubjectView::reloadSubject()
{
}

void KitaSubjectView::loadThread(QListViewItem* item)
{
  QString datName = item->text(3);
  KURL datURL = m_boardURL;
  datURL.addPath("/dat/" + datName);
  emit signalShowThread(datURL, m_boardURL, m_boardName);
}

void KitaSubjectView::slotLoadBoard(const KURL& url, const QString& boardName)
{
  m_boardURL = url;
  m_boardName = boardName;
  
  KIO::SlaveConfig::self()->setConfigData("http", url.host() , "UserAgent", "Monazilla/1.00 (test)");
  
  QString tmpFile;
  KURL subjectURL = KURL(url, "subject.txt");
  if(KIO::NetAccess::download(subjectURL, tmpFile)) {
    QIODevice* tmpDevice = KFilterDev::deviceForFile(tmpFile, "application/x-gzip");
    tmpDevice->open(IO_ReadOnly);
    
    QTextStream stream(tmpDevice);
    stream.setCodec(QTextCodec::codecForName("Shift_JIS"));
    
    // clear list
    subjectList->clear();
    
    // parse subject.txt(only one format...)    
    QRegExp regexp("(\\d+\\.dat)<>(.*)\\((\\d+)\\)");
    QString line;
    int row=1;
    
    while((line = stream.readLine()) != QString::null) {
      int pos = regexp.search(line);
      if(pos != -1) {
        QString fname = regexp.cap(1);
        QString subject = regexp.cap(2);
        QString num = regexp.cap(3);
  
        new QListViewItem(subjectList, QString("%1").arg(row, 4), subject, num, fname);
        row++;
      }
    }
        
    KIO::NetAccess::removeTempFile(tmpFile); 
  }
}
