/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITATHREADLISTVIEW_H
#define KITATHREADLISTVIEW_H

#include "threadlistviewbase.h"

#include <klistview.h>
#include <kparts/browserextension.h>

enum ThreadListViewRows {
    Col_Begin = 0,
    Col_Mark = 0,
    Col_ID,
    Col_Icon,
    Col_Subject,
    Col_ResNum,
    Col_ReadNum,
    Col_ViewPos,
    Col_Unread,
    Col_Since,
    Col_Speed,
    Col_Board,
    Col_DatURL,
    Col_MarkOrder,
    Col_IDOrder,
    Col_End = Col_IDOrder
};

struct Col_Attr
{
    QString labelName; // for header's label
    QString itemName; // for header's popupItem
    QString keyName;  // for KConfig's key
    bool showDefault; // default setting.
};


namespace Kita
{
    class Thread;
    /**
    @author Hideki Ikemoto
    */
    class ThreadListView : public Kita::ThreadListViewBase
    {
        Q_OBJECT

    public:
        ThreadListView( QWidget* parent = 0, const char *name = 0 );
        ~ThreadListView();

    protected:
        static struct Col_Attr s_colAttr[];
        QStringList m_prevquery;
        unsigned m_nextHitIndex;
        QValueList<KListViewItem *> m_hitList;

        void insertSearchCombo();
        QStringList parseSearchQuery( const QString& input );
        void searchNext( const QStringList& input );
        void searchAll( const QStringList& query );

    protected slots:
        void slotHideButton( bool on );
        void slotMouseButtonClicked( int, QListViewItem* );

    private slots:
        void slotSearchButton();

    signals:
        void openURLRequestExt( const KURL& url, const KParts::URLArgs& args = KParts::URLArgs(),
                                QString mimetype = QString::null,
                                int usr1 = 0, int usr2 = 0,
                                const KURL& usrUrl1 = KURL(),
                                const KURL& usrUrl2 = KURL(),
                                const QString& usrStr1 = QString::null,
                                const QString& usrStr2 = QString::null );
        void bookmarked( const QString& datURL, bool on );
    };

    class ThreadListViewItem : public KListViewItem
    {
    public:
        ThreadListViewItem( QListView* parent ) : KListViewItem( parent ) {};
        virtual ~ThreadListViewItem() {};

        virtual int compare( QListViewItem* i, int col, bool ascending ) const;
    };
}

#endif
