/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITADOMTREE_H
#define KITADOMTREE_H

#include <qvaluevector.h>
#include <khtml_part.h>

namespace Kita
{
    class DatInfo;
}

class KitaDomTree
{
    Kita::DatInfo* m_datInfo;
    int m_bufLng;

    /*

      When readNum = m_datInfo->getReadNum(), the responses are

      No.1 <-- shown --> m_templateNum <-- not shown -->
      m_topNum <-- shown ---> m_bottomNum <-- not shown --> readNum.

      If m_topNum <= i <= m_bottomNum, then m_resshown[i] = TRUE.
      
      If m_bottomNum < i <= readNum, where m_bottomNum < readNum,
      then m_resshown[i] = FALSE.
    */
    int m_templateNum;
    int m_topNum;
    int m_bottomNum;
    int m_headerMaxNum;
    QValueVector < bool > m_resshown; /* the res is shown */
    QValueVector < bool > m_resparsed; /* the res is parsed */

    /* DOM elements */
    DOM::HTMLDocument m_hdoc; /* root node of document*/
    QValueVector < DOM::Element > m_res; /* the vector of the element of response */
    DOM::Element m_header;
    DOM::Element m_footer;
    DOM::Element m_kokoyon;
    DOM::Element m_tugi100;
    DOM::Element m_mae100;

    /*-------------------------------------------------------------*/

public:

    KitaDomTree( const DOM::HTMLDocument& hdoc, const KURL& datURL );
    ~KitaDomTree();

    /* rendering functions */

    bool parseRes( int num );
    bool appendRes( int num );
    bool removeRes( int num );
    void redraw( bool force );

    /* information */

    const bool isResShown( int num ) const;
    const int getTopResNumber() const;
    const int getBottomResNumber() const;
    const int getTemplateNumber() const;
    const bool isMae100Shown() const;

    /* header Node, footer Node, kokomadeyonda Node, etc... */

    void appendTemplate( int tmnNum );
    void appendFooterAndHeader();

    void appendKokoyon();

    void appendTugi100();
    void removeTugi100();

    void appendMae100();
    void removeMae100();

    void createCommentNode( const QString& comment, const QString& idstr, int beforeBR, int afterBR, bool binsert );
    void createBeltNode( const QString& idstr );


private:

    void appendANode( DOM::Element rootnode, const QString& linkstr, const QString& comment );
    void updateFooterOrHeader( DOM::Element& targetelm, QString strType );
    void createFooterOrHeader( QString strType );
    void createKokoyon();
    void createTugi100();
    void createMae100();
};



#endif
