/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITALISTVIEWITEM_H_
#define _KITALISTVIEWITEM_H_

#include <klistview.h>

enum SubjectRows {
    Col_Begin = 0,
    Col_Mark = 0,
    Col_ID,
    Col_Icon,
    Col_Subject,
    Col_ResNum,
    Col_ReadNum,
    Col_ViewPos,
    Col_Unread,
    Col_Since,
    Col_Speed,
    Col_Board,
    Col_DatURL,
    Col_MarkOrder,
    Col_IDOrder,
    Col_End = Col_IDOrder
};


namespace Kita
{
    class ListViewItem : public KListViewItem
    {
	QColor m_textColor;  /* text color */
	QColor m_baseColor;  /* background color */
	    
      public:

	ListViewItem( QListView *parent, QListViewItem *after,
		      QString, QString = QString::null,
		      QString = QString::null, QString = QString::null,
		      QString = QString::null, QString = QString::null,
		      QString = QString::null, QString = QString::null);    

	ListViewItem( QListViewItem *parent, QListViewItem *after,
		      QString, QString = QString::null,
		      QString = QString::null, QString = QString::null,
		      QString = QString::null, QString = QString::null,
		      QString = QString::null, QString = QString::null);    

	ListViewItem( QListView* parent, QString = QString::null, QString = QString::null );

	ListViewItem( QListViewItem* parent, QString = QString::null, QString = QString::null );
	
	~ListViewItem();

	void setColor( QColor textColor, QColor baseColor );
	virtual void paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int align );

      private:
	void init();
    };

    /*----------------------------------------*/
    
    /* for KitaSubjectView */
    class SubjectListViewItem : public Kita::ListViewItem
    {
	SubjectListViewItem( QListView* parent );
	~SubjectListViewItem();
	
    public:
        virtual int compare( QListViewItem* i, int col, bool ascending ) const;
    };
    
} 




#endif
