/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "listviewitem.h"


namespace Kita
{
    ListViewItem::ListViewItem( QListView *parent, QListViewItem *after,
				 QString label1, QString label2, QString label3, QString label4,
				 QString label5, QString label6, QString label7, QString label8)
	: KListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8)
    {
	init();
    }

    ListViewItem::ListViewItem( QListViewItem *parent, QListViewItem *after,
				 QString label1, QString label2, QString label3, QString label4,
				 QString label5, QString label6, QString label7, QString label8)
	: KListViewItem(parent, after, label1, label2, label3, label4, label5, label6, label7, label8)
    {
	init();
    }

    ListViewItem::ListViewItem( QListView* parent, QString label1, QString label2  )
	: KListViewItem( parent, label1, label2 )
    {
	init();	
    }

    ListViewItem::ListViewItem( QListViewItem* parent, QString label1, QString label2  )
	: KListViewItem( parent, label1, label2 )
    {
	init();
    }
    
    ListViewItem::~ListViewItem()
    {}

    /* private */
    void ListViewItem::init()
    {
	QColorGroup colors = listView()->viewport()->colorGroup();
	m_textColor = colors.text();
	m_baseColor = colors.base();
    }

    /* public */
    void ListViewItem::setColor( QColor textColor, QColor baseColor )
    {
	m_textColor = textColor;
	m_baseColor = baseColor;
    }

    /* public */ /* virtual */
    void ListViewItem::paintCell( QPainter *p, const QColorGroup &cg,
      int column, int width, int align )
    {
        QColorGroup color = cg;
        color.setColor( QColorGroup::Text, m_textColor );
        color.setColor( QColorGroup::Base, m_baseColor );
        KListViewItem::paintCell( p, color, column, width, align );
    }

    /*----------------------------------------*/


    SubjectListViewItem::SubjectListViewItem( QListView* parent )
	: Kita::ListViewItem( parent )
    {}

    SubjectListViewItem::~SubjectListViewItem()
    {}
    
    /* public */ /* virtual */    
    int SubjectListViewItem::compare( QListViewItem* i, int col, bool ascending ) const
    {
	switch ( col ) {
	case Col_ResNum:
	case Col_ReadNum:
	case Col_Unread:
	    return i->key( col, ascending ).toInt() - key( col, ascending ).toInt();
	case Col_ID:
	    return key( Col_IDOrder, ascending ).toInt() - i->key( Col_IDOrder, ascending ).toInt();
	case Col_Mark:
	    return QString::localeAwareCompare( i->key( Col_MarkOrder, ascending ), key( Col_MarkOrder, ascending ) );
	case Col_Since:
	    return QString::localeAwareCompare( i->key( col, ascending ), key( col, ascending ) );
	case Col_Speed:
	    return static_cast<int>( i->key( col, ascending ).toDouble() * 1000 - key( col, ascending ).toDouble() * 1000 );
	default:
	    return QString::localeAwareCompare( key( col, ascending ), i->key( col, ascending ) );
	}
    }
} 
