/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITATHREADINDEX_H
#define KITATHREADINDEX_H

#define USE_INDEX

#include <qstring.h>

class KURL;
class KConfig;

namespace Kita
{
    class Thread;
    
    /**
    @author Hideki Ikemoto
    */
    class ThreadIndex
    {
    public:
        static QString getSubject( const KURL& url );
        static void setSubject( const KURL& url, const QString& str );

        static int getResNum( const KURL& url );
        static void setResNum( const KURL& url, int resNum );

        static int getReadNum( const KURL& url );
        static void setReadNum( const KURL& url, int readNum );

        static int getViewPos( const KURL& url );
        static void setViewPos( const KURL& url, int viewPos );

	/*---------------------------------*/
	
	static void loadIndex( Kita::Thread* thread, const KURL& url );
	static void saveIndex( const Kita::Thread* thread, const KURL& url );	

      private:
	
        static QString getSubjectPrivate( KConfig& config );
        static void setSubjectPrivate( const QString& str, KConfig& config );

        static int getResNumPrivate( const KURL& url, KConfig& config );
        static void setResNumPrivate( int resNum, KConfig& config );

        static int getReadNumPrivate( const KURL& url, KConfig& config );
        static void setReadNumPrivate( int readNum, KConfig& config );

        static int getViewPosPrivate( KConfig& config );
        static void setViewPosPrivate( int viewPos, KConfig& config );
    };
}

#endif
