/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAKITA_MISC_H
#define KITAKITA_MISC_H

#include "boardmanager.h"

#include <qstring.h>

class KURL;
class QDateTime;

namespace DOM
{
    class HTMLDocument;
    class Element;
}

struct RESDAT;


/* URL conversion mode. see also Kita::convertURL()  */
enum{
    URLMODE_DAT,
    URLMODE_THREAD
};


/* parse mode */
enum{
    PARSEMODE_DOM,
    PARSEMODE_HTML,
    PARSEMODE_TEXT
};


namespace Kita
{
    /**
     * @author Hideki Ikemoto
     */

    /*------------------------------*/    
    /* text codecs */
    QString qcpToUnicode( const QString& str );
    QString utf8ToUnicode( const QString& str );
    QString ecuToUnicode( const QString& str );

    
    /*------------------------------*/
    /* conversion of DAT  */
    QString DatToHtml( const QString& rawData, int num, bool showAddr );
    QString ResDatToHtml( const RESDAT& resdat, int num, bool showAddr );
    

    /*------------------------------*/
    /* conversion of URL */
    KURL getDatURL( const KURL& url , QString& refstr );
    KURL getDatURL( const KURL& url );

    QString getThreadURL( const KURL& url, QString& refstr );
    QString getThreadURL( const KURL& url );

    QString convertURL( int mode, const KURL& url , QString& refstr );

    QString datToOfflaw( const KURL& datURL );
    
    
    /*------------------------------*/    
    /* utilities */
    bool mkdir( const QString& path );
    QString unescape( const QString& str );
    uint datToSince( const KURL& datURL );
    int isEqual( const QChar *cdat, const QString& str );
    int stringToPositiveNum( const QChar *cdat, const unsigned int length );
    

    /*------------------------------*/
    /* internal parsing funtions */

    
    /* for MACHI BBS */
    void InitParseMachiBBS();
    QString ParseMachiBBSOneLine( const QString& inputLine, int& nextNum );
    
    /* for JBBS */
    QString ParseJBBSOneLine( const QString& line, int& nextNum );


    /* for Flash CGI/Mini Thread */
    QString ParseFlashCGIOneLine( const QString& line );

    
    /* for 2ch */
    void parseTITLEdat( int mode, DOM::HTMLDocument& hdoc, int num,
			bool showMailAddress, const RESDAT& resdat,
			DOM::Element &titlenode, QString& titletext );
    void parseTITLEdatText( int mode, int num, bool showMailAddress,
				   const RESDAT& resdat, QString& titletext );

    void parseBODYdat( int mode, const QString &rawStr, DOM::HTMLDocument& hdoc,
			      bool showAA, DOM::Element &bodynode, QString& bodytext );
    void parseBODYdatText( int mode, const QString &rawStr, QString& bodytext );

    QString parseSpecialChar( const QChar *cdat, unsigned int& pos );
    void parseDateId( const QString& str, RESDAT& resdat );
    bool parseResDat( RESDAT& resdat, QString& subject );
    bool parseLink( const QChar *cdat, const unsigned int length,
			   QString& linkstr, QString& linkurl, unsigned int& pos );
    bool parseResAnchor( const QChar *cdat, const unsigned int length,
				QString& linkstr, int* refNum, unsigned int& pos );
    bool createResAnchor( int mode, const QString &rawStr, DOM::HTMLDocument& hdoc ,
		     DOM::Element &bodynode, QString& bodytext,
		     const QChar *chpt, unsigned int &i, unsigned int &index, QString& lineStr );


    
    /*--------------------------------*/
    /* obsolete */
    QString datToBoard( const KURL& datURL );
    int boardType( const KURL& url );
}

#endif
