/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "favoritethreads.h"
#include "thread.h"
#include "threadindex.h"
#include "boardmanager.h"
#include "datmanager.h"
#include "kita_misc.h"

#include <kdebug.h>

#include <qstylesheet.h>
#include <qdom.h>

FavoriteThreads* FavoriteThreads::instance = 0;

FavoriteThreads::FavoriteThreads()
{}

FavoriteThreads::~FavoriteThreads()
{}

FavoriteThreads* FavoriteThreads::getInstance()
{
    if ( ! instance ) {
        instance = new FavoriteThreads();
    }
    return instance;
}

void FavoriteThreads::insert( const QString& datURL )
{
    if ( ! m_threadList.contains( datURL ) ) {
        m_threadList.append( datURL );
    }
}

void FavoriteThreads::remove( const QString& datURL )
{
    m_threadList.remove( datURL );
}

bool FavoriteThreads::contains( const QString& datURL )
{
    if ( getInstance() ->m_threadList.contains( datURL ) ) {
        return true;
    } else {
        return false;
    }
}

const QValueList<QString> FavoriteThreads::threadList() const
{
    return m_threadList;
}

bool FavoriteThreads::readFromXML( const QString& xml )
{
    FavoriteThreads * instance = FavoriteThreads::getInstance();
    instance->m_threadList.clear();

    QDomDocument document;
    if ( ! document.setContent( xml, true ) ) {
        return false;
    }

    QDomElement root = document.documentElement();

    QDomNode node = root.firstChild();
    while ( !node.isNull() ) {
        if ( node.isElement() &&
                node.nodeName() == QString( "thread" ) &&
                node.namespaceURI() == QString( "http://kita.sourceforge.jp/ns/thread" ) ) {
            processThreadNode( node );
        }
        node = node.nextSibling();
    }
    return true;
}

void FavoriteThreads::processThreadNode( QDomNode& node )
{
    QDomNode datURLNode = node.namedItem( "daturl" );
    QDomNode nameNode = node.namedItem( "name" );

    if ( !datURLNode.isElement() || !nameNode.isElement() ) return;

    QString url = datURLNode.toElement().text();
    QString name = nameNode.toElement().text();

    KURL datURL = Kita::getDatURL( url );
    Kita::Thread* thread = Kita::Thread::getByURL( datURL );
    thread->setThreadName( name );
    Kita::ThreadIndex::loadIndex( thread, datURL );
    
    FavoriteThreads::getInstance() ->insert( datURL.prettyURL() );
}

const QString FavoriteThreads::toXML() const
{
    QDomDocument document;

    //    QDomProcessingInstruction pi = document.createProcessingInstruction( "xml", "version=\"1.0\"" );
    //    document.appendChild( pi );

    QDomElement root = document.createElementNS( "http://kita.sourceforge.jp/ns/favorites", "favorites" );
    document.appendChild( root );

    QValueList<QString>::const_iterator it;
    for ( it = threadList().begin(); it != threadList().end(); ++it ) {
        QString datURL = ( *it );
        QDomElement threadElement = document.createElementNS( "http://kita.sourceforge.jp/ns/thread", "thread" );
        root.appendChild( threadElement );

        QDomElement datURLElement = document.createElement( "daturl" );
        threadElement.appendChild( datURLElement );
        datURLElement.appendChild( document.createTextNode( datURL ) );

        QString threadName = Kita::DatManager::threadName( datURL );
        QDomElement nameElement = document.createElement( "name" );
        threadElement.appendChild( nameElement );
        nameElement.appendChild( document.createTextNode( threadName ) );
  	 
        QString resNum = QString::number( Kita::DatManager::getResNum( datURL ) ); 	 
        QDomElement resNumElement = document.createElement( "resnum" ); 	 
        threadElement.appendChild( resNumElement ); 	 
        resNumElement.appendChild( document.createTextNode( resNum ) ); 	 
  	 
        // board 	 
        QDomElement board = document.createElementNS( "http://kita.sourceforge.jp/ns/board", "board" );   
        threadElement.appendChild( board ); 	 

        QString boardURL = Kita::BoardManager::boardURL( datURL ); 	 
        QDomElement boardURLElement = document.createElement( "url" ); 	 
        board.appendChild( boardURLElement ); 	 
        boardURLElement.appendChild( document.createTextNode( boardURL ) ); 	 

        QString boardName = Kita::BoardManager::boardName( boardURL ); 	 
        QDomElement boardNameElement = document.createElement( "name" ); 	 
        board.appendChild( boardNameElement ); 	 
        boardNameElement.appendChild( document.createTextNode( boardName ) );
    }
    return document.toString( 0 );
}

void FavoriteThreads::replace( QString fromURL, QString toURL )
{
    if( FavoriteThreads::getInstance() == NULL ) return;
    QValueList<QString>& threadList = FavoriteThreads::getInstance() ->m_threadList;
    QValueList<QString>::iterator it;
    for ( it = threadList.begin(); it != threadList.end(); ++it ) {
        QString url = ( *it );
        if ( url.find( fromURL ) == 0 ) {
            url = url.replace( 0, fromURL.length(), toURL );
            threadList.remove( it );
            threadList.prepend( url );
            it = threadList.begin();
        }
    }
}
