/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITADATMG_H
#define KITADATMG_H

#include <qvaluelist.h>

class QMutex;
class KURL;
class QObject;
class QStringList;

namespace DOM
{
    class HTMLDocument;
    class Element;
}

namespace Kita
{

    class DatInfo;
    typedef QValueList<DatInfo*> DatInfoList;

    class DatManager
    {
        static DatInfoList m_datInfoList;
        static QMutex m_mutex;

    public:

        static bool createDatInfo( const KURL& url );
        static DatInfo* getDatInfoPointer( const KURL& url );
        static void deleteAllDatInfo();

        /* caching */
        static bool updateCache( const KURL& url , const QObject* parent );
        static int getResponseCode( const KURL& url );
        static int getServerTime( const KURL& url );
        static bool deleteCache( const KURL& url );
        static bool isLoadingNow( const KURL& url );
        static void stopLoading( const KURL& url );


        /* lock, unlock */
        static void lock ( const KURL& url );
        static void unlock( const KURL& url );

        /* string data */
        static const QString& getRawDat( const KURL& url );
        static const QString& getDat( const KURL& url, int num );
        static const QString& getId( const KURL& url, int num );
        static const QString& getName( const KURL& url, int num );
        static const QString& getBody( const KURL& url, int num );
        static QString getPlainName( const KURL& url, int num );
        static QString getPlainBody( const KURL& url, int num );
        static QString getPlainTitle( const KURL& url, int num );

        static const QString threadName( const KURL& url ); /* = subject of thread */
        static const QString threadID( const KURL& url );

        static const QString getCachePath( const KURL& url );
        static const QString getCacheIndexPath( const KURL& url );

        /* HTML data */
        static QString getHtml( const KURL& url, int startnum, int endnum );
        static QString getHtmlByID( const KURL& url, const QString& strid, int &count );
        static QString getTreeByRes( const KURL& url, const int rootnum, int &count );
        static QString getTreeByResReverse( const KURL& url, const int rootnum, int &count );

        /* DOM element */
        static bool getDomElement( const KURL& url, int num, DOM::HTMLDocument& hdoc, DOM::Element& retelm );

        /* numerical data */
        static int getResNum( const KURL& url );
        static int getReadNum( const KURL& url );
        static int getViewPos( const KURL& url );
        static void setViewPos( const KURL& url, int num );
        static int getDatSize( const KURL& url );
        static int getNumByID( const KURL& url, const QString& strid );
	
	
        /* another information */
        static bool isThreadEnrolled( const KURL& url );
        static bool is2chThread( const KURL& url );
        static bool isResValid( const KURL& url , int num );
        static bool isBroken( const KURL& url );
        static bool isResBroken( const KURL& url , int num );
        static bool checkID( const KURL& url, const QString& strid, int num );
        static bool checkWord( const KURL& url, QStringList& stlist, int num, bool checkOR );
        static bool isMarked( const KURL& url, int num );
        static void setMark( const KURL& url, int num, bool mark );


        /* abone check */
        static bool checkAbone( const KURL& url, int num );
        static void resetAbone( const KURL& url );

        /* check if the thread is shown on the main thread tab. */
        static bool isMainThreadOpened( const KURL& url );
        static void setMainThreadOpened( const KURL& url, bool isOpened );

        /* obsolete. Don't use them. */
	
        static const QString threadURL( const KURL& url );
	
    private:

        static DatInfo* getDatInfo( const KURL& url, bool checkCached = TRUE );
        static DatInfo* searchDatInfo( const KURL& url );
        static DatInfo* enrollDatInfo( const KURL& url, bool checkCached );
    };

}

#endif
