/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITAACCESS_H
#define KITAACCESS_H

#include <kurl.h>

#include <qobject.h>

namespace KIO
{
    class Job;
}

namespace Kita
{
    class Thread;

    /**
    @author Hideki Ikemoto
    */
    class Access : public QObject
    {
        Q_OBJECT

    public:
        Access( const KURL& datURL );
        virtual ~Access() {};

	void init();
        QString get();
        void killJob();
        void stopJob();
        int serverTime();
        void getcache();
        bool getupdate( int readNum );
        int responseCode();

    protected:
        void writeCacheData();
        void emitDatLineList( const QString& dataStream );	

        const KURL m_datURL;
        KIO::Job* m_currentJob;
        QString m_threadData;
        QString m_header;
        int m_dataSize;
        bool m_firstReceive;
        bool m_invalidDataReceived;
        int m_bbstype;	
        int m_readNum;
        QString m_lastLine;

    private slots:
        void slotReceiveThreadData( KIO::Job* job, const QByteArray& data );
        void slotThreadResult( KIO::Job* job );

    signals:
        void redirection( const QString& );
        void receiveData( const QStringList& );
        void finishLoad();
    };

    class OfflawAccess : public Access
    {
        Q_OBJECT

    public:
        OfflawAccess( const KURL& datURL ) : Access( datURL ) {};
        virtual ~OfflawAccess() {};

        QString get();

    private slots:
        void slotReceiveThreadData( KIO::Job* job, const QByteArray& data );
        void slotThreadResult( KIO::Job* job );
    };
}

#endif
