/***************************************************************************
*   Copyright (C) 2004 by Hideki Ikemoto , (c) 2004 by 421                *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITAIMGTABWIDGET_H
#define KITAIMGTABWIDGET_H

#include "kitatabwidgetbase.h"

class KURL;
class KitaImgView;
class KSelectAction;

/*------------------------------------------------*/


class KitaImgTabWidget : public KitaTabWidgetBase
{
    Q_OBJECT

    KSelectAction* m_sizeaction;
    
public:
    KitaImgTabWidget( QWidget* parent, const char* name = 0, WFlags fl = 0 );
    ~KitaImgTabWidget();

public slots:
    void slotOpenURL( const KURL& url, const KURL& datURL );
    void slotCloseImgView( const KURL& url );
    void slotUpdateView( const KURL& url );
    void slotRedrawImage( const KURL& url );

private slots:
    void slotReceiveImgData( const KURL& url, unsigned int size , unsigned int totalsize );

protected:
    virtual void deleteWidget( QWidget* w );

private:
    KitaImgView* createImgView( const KURL& url, const KURL& datURL );
    KitaImgView* findImgView( const KURL& url );
    KitaImgView* isImgView( QWidget* w );

    /*------------------------------------*/
    /* Image View actions */

private:
    void setupActions();

public slots:
    void slotStopLoading( int idx = -1 );
    void slotCancelMosaic( int idx = -1 );
    void slotCancelAllMosaic();
    void slotShowFitToWin( int idx = -1 );
    void slotOriginalSize( int idx = -1 );
    void slotZoomIn( int idx = -1 );
    void slotZoomOut( int idx = -1 );
    void slotCopyURL( int idx = -1 );
    void slotOpenBrowser( int idx = -1 );
    void slotDelete( int idx = -1 );
    void slotSave( int idx = -1 );
    void slotCloseErrorTab();
    void slotReload( int idx = -1 );
    void slotOpenThread( int idx = -1 );
    void slotSelectSize();
};


/*--------------------------------------------------*/


class KitaImgTabBar : public KitaTabBarBase
{
    Q_OBJECT

public:
    KitaImgTabBar( QWidget* parent = 0, const char* name = 0 );
    ~KitaImgTabBar();

private:
    virtual void showPopupMenu( int idx, QPoint global );
};


/*--------------------------------------------------*/


class KitaImgDock : public KitaDockWidgetBase
{
    Q_OBJECT

    KitaImgTabWidget* m_imgTab;

public:
    KitaImgDock( KDockManager* dockManager,
                 const char* name,
                 const QPixmap &pixmap,
                 QWidget* parent = 0L,
                 const QString& strCaption = QString::null,
                 const QString& strTabPageLabel = QString::fromLatin1( " " ),
                 WFlags f = 0 );
    ~KitaImgDock();

    KitaImgTabWidget* setup();

public slots:
    void slotOpenURL( const KURL& url, const KURL& datURL = KURL(), bool activate = TRUE );
};


#endif
