/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITA_H_
#define _KITA_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kparts/dockmainwindow.h>

class KPrinter;
class KToggleAction;
class KURL;
class KLineEdit;

class KitaBoardDock;
class KitaBoardTabWidget;
class KitaSubjectTabWidget;
class KitaSubjectDock;
class KitaThreadDock;
class KitaThreadTabWidget;
class KitaImgDock;
class KitaImgTabWidget;
class KitaWriteDock;
class KitaWriteTabWidget;

namespace KParts
{
    class URLArgs;
    class Part;
}

/**
 * This class serves as the main window for Kita.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */

class KitaMainWindow : public KParts::DockMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    KitaMainWindow();

    /**
     * Default Destructor
     */
    virtual ~KitaMainWindow();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load( const KURL& url );

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent( QDragEnterEvent* event );
    virtual void dropEvent( QDropEvent* event );

    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties( KConfig* );

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties( KConfig* );

private slots:
    void favoritesEdit();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
    void windowToggleView();
    void settingsMenuAboutToShow();
    void slotEditCopy();
    void resetWindowsCust();
    void resetWindowsDef1();
    void resetWindowsDef2();
    void resetWindowsDef3();
    void closeSubjectView();
    void slotCheckBoardToggleAction( bool check );
    void slotCheckSubjectToggleAction( bool check );
    void slotCheckNaviToggleAction( bool check );
    void slotCheckImgToggleAction( bool check );
    void slotCheckWriteToggleAction( bool check );
    void login();

    void slotSetMainStatusbar( const QString& statusStr );
    void slotOpenURLRequest( const KURL& url, const KParts::URLArgs& );
    void slotOpenURLRequestExt( const KURL& url, const KParts::URLArgs& args,
                                QString mimetype = QString::null,
                                int usr1 = 0, int usr2 = 0,
                                const KURL& usrUrl1 = KURL(),
                                const KURL& usrUrl2 = KURL(),
                                const QString& usrStr1 = QString::null,
                                const QString& usrStr2 = QString::null );

    void setFont( const QFont& font );
    void slotURLLine();
    void setUrl( const KURL& url );
    void bookmark( const QString& datURL, bool on );
    void slotSetMainCaption( const QString& captionStr );

private:
    KLineEdit* m_urlLine;

    KPrinter *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
    KToggleAction *m_boardListAction;
    KToggleAction* m_subjectListAction;
    KToggleAction* m_showImgViewAction;
    KToggleAction* m_showNaviAction;
    KToggleAction* m_showWriteDockAction;
    KAction* m_toggleViewAction;

    KDockWidget* m_dummyDock; /* dummy MainDockWidget */
    KitaBoardDock* m_boardDock;
    KitaSubjectDock* m_subjectDock;
    KitaThreadDock* m_threadDock;
    KitaThreadDock* m_naviDock;
    KitaImgDock* m_imgDock;
    KitaWriteDock* m_writeDock;

    KitaThreadTabWidget* m_threadTab;
    KitaBoardTabWidget* m_boardTab;
    KitaSubjectTabWidget* m_subjectTab;
    KitaImgTabWidget* m_imgTab;
    KitaThreadTabWidget* m_naviTab;
    KitaWriteTabWidget* m_writeTab;

    void setupAccel();
    void setupActions();
    void setupView();
    void loadCache();
    void saveCache();
    void loadFavorites();
    void saveFavorites();
    void loadFavoriteBoards();
    void saveFavoriteBoards();
    void loadCompletion();
    void saveCompletion();
    void loadStyleSheet();
    void saveStyleSheet();
    void loadAsciiArt();
    void saveAsciiArt();
    void loadAboneIDList();
    void saveAboneIDList();
    void loadAboneNameList();
    void saveAboneNameList();
    void loadAboneWordList();
    void saveAboneWordList();
    void resetWindows( int pattern );

signals:
    void favoritesUpdated();
    void switchSubjectView();
};

#endif // _KITA_H_
