/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef FAVORITELISTVIEW_H
#define FAVORITELISTVIEW_H

#include "threadlistview.h"

#include "libkita/thread.h"

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/
class FavoriteListView : public Kita::ThreadListView
{
    Q_OBJECT

public:
    /**
     * Constructor
     *
     * @param parent parent widget.
     * @param name widget name.
     */
    FavoriteListView( QWidget* parent = 0, const char* name = 0 );

    /**
     * Destructor
     */
    ~FavoriteListView();

public slots:
    void slotUpdateSubject( const KURL& url );

private slots:

    /**
     * @param item clicked item.
     */
    void loadThread( QListViewItem* item );
    void slotContextMenuRequested( QListViewItem*, const QPoint&, int );
    void slotReloadButton();

    /**
     *
     */
    void update();

signals:
    void openBoardRequested( const QString&, bool );
};

#endif
