/* $Id: kircd.h,v 1.68 2006/12/20 13:04:37 ichiro Exp $ */
/* #define DEBUG */
/*
 * Copyright (c) 2004, 2005, 2006
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef DEBUG
#define DPRINTF(n, x)	if (debug > (n)) printf x
#else
#define DPRINTF(n, x)
#endif

#if !HAVE_BZERO && HAVE_MEMSET
#define bzero(buf, bytes)  ((void)memset(buf, 0, bytes))
#endif

#include <glib/gthread.h>

#define CLIENT 0
#define SERVER 1

/* length of hostname and portnumber */
#define HOSTNAME_LEN 128
#define PORT_LEN 10

/* buffer size */
#define SBUFLEN 16384
#define LBUFLEN 16384
#define HTTPBUF 16384

#define CONFSEP ";\n"

/* GET /channel?? HTTP/1.1 */
/* GET/POST    ----> length 5 */
/* channel??   ----> length 10 */
#define M_LEN 5
#define URI_LEN 10

/* channel */
#define CH_MAX 20
#define C_NAME 40

/* buffer lines per irc channel */
#define CHBUF_MAX 30

/* command length */
#define CMD_LEN 20

/* auth length(cookie) */
#define AUTH_LEN 64
#define CDATE_LEN 64

/* max cache line */
#define C_HISTORY_NUM 31

/* max length of name */
#define REALNAME_LEN 64
#define NAME_LEN 10

/* max length of IRC message */
#define IRC_MAX 1000

/* subtopic length */
#define SUBTOPIC_LEN 20

/* emoji */
#define DAT_ROW 699
#define DAT_COL 5

#define DAT_NUM 0
#define D_KEY   1
#define AU_KEY  2
#define D_STR   3
#define AU_STR  4

/* version check */
#define VC_HOST "cvs.sourceforge.jp"
#define VC_PORT "80"
#define VC_URI "/cgi-bin/viewcvs.cgi/*checkout*/kircd/kircd/configure.in"
#define VC_INT 6

struct tparam {
	int socket_number;
	int server_socket;

	char real_nickname[REALNAME_LEN];

	/* recieve buffer */
	int s_read;
	int s_count;
	int s_empty;	/* recieve buffer empty */
	char *s_buff;
	char *l_buff;
	int s_lock;

	int max_line;
	int line_reverse;
	int show_topic;
	int cookie_expire;
	char name[CH_MAX][C_NAME];
	int  ch_count;
	char data[CH_MAX][C_HISTORY_NUM][IRC_MAX * 2];
	int  history_count[CH_MAX];
	int  read_count[CH_MAX];
	char topic[CH_MAX][IRC_MAX];
	char member_names[CH_MAX][IRC_MAX];
	int  member_count[CH_MAX];

	/* transfer buffer */
	int  t_empty;	/* trans buffer empty */
	int  t_lock;	/* trans buffer writing */
	char postdata[IRC_MAX * 2];

	/* auth (copy) */
	int  auth_method;
	char auth_user[AUTH_LEN];
	char auth_pass[AUTH_LEN];
	char uid[AUTH_LEN];
	int  auth_flag;
	int  regist_done;
	char user_agent[IRC_MAX * 2];
	char store_message[SBUFLEN];

	/* carrier */
	int  phone_carrier;
#define DOCOMO_PDC	0x0001
#define DOCOMO_FOMA	0x0002
#define AU_EZWEB	0x0003
#define OTHER		0x0004

	/* send buffer */
	char *send_buf;
	int  send_buflen;

	/* timer */
	time_t last_access;
	time_t timeout;

	/* new version check */
	int new_available;
	time_t last_check;
};

struct config {
	char hostname[HOSTNAME_LEN];
	char server_port[PORT_LEN];
	char client_port[PORT_LEN];
	char password[REALNAME_LEN];
	char username[REALNAME_LEN];
	char nickname[REALNAME_LEN];

	/* auth */
	char auth_user[AUTH_LEN];
	char auth_pass[AUTH_LEN];
	int max_line;
	int line_reverse;
	int show_topic;
	int auth_method;
	int cookie_expire;

	/* timer */
	time_t timeout;
};

/* emoji data */
const int emoji[DAT_ROW][DAT_COL];
extern int emoji_encode(unsigned char *, int);
extern int emoji_decode(unsigned char *, int);

int main(int ac, char *av[]);
int get_addr(struct addrinfo, const char*, const char*, int);
void init(int, struct config *);
gpointer watch(gpointer);
gpointer lineget(gpointer);
extern gpointer httpd(gpointer);

extern int send_postdata(int, char *);
extern void send_buf(struct tparam *, char *);
extern int readconf(unsigned char *, struct config *);
extern int keitai_start(struct tparam *);
extern int priv_recv(struct tparam *);
extern int topic_recv(struct tparam *);
extern int part_recv(struct tparam *);
extern int channel_delete(struct tparam *, char *);
extern int join_recv(struct tparam *);
extern int ctcp_recv(struct tparam *, char *, char *);
extern int channel_make(struct tparam *, char *);
extern int names_recv(struct tparam *);
extern int ping_recv(struct tparam *);
extern int send_names(struct tparam *, char *);
extern int nick_recv(struct tparam *);

extern int send_join(struct tparam *, char *);
extern int send_part(struct tparam *, char *);

extern int url_decode_jis(char *, int);
extern int decode_jis2cp932(char *);

extern int charconv(char *, size_t, const char *,
	size_t, const char *, const char *);
extern int channel_encode(char *, char *);
extern int channel_decode(char *, char *);
extern int ltgt_encode(char *, char *);
extern char * base64_decode(char *);
extern char * href_conv(char *);
extern int strcmp2(char *, char *);
extern int count_user(char *);

extern void print_easybutton(struct tparam *);
extern char* find_uid(char *);

extern int version_check(struct tparam *, char *);
