/* $Id: emoji.c,v 1.13 2006/01/15 14:59:38 ichiro Exp $ */
/*
 * Copyright (c) 2004, 2005, 2006
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <regex.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

#include "kircd.h"

#ifdef HAVE_ICONV
#include <iconv.h>
#endif

extern int debug;

int emoji_encode(unsigned char *src, int phone_type)
{
        int i, j, k, len;
	int sum;
	unsigned char buffer[IRC_MAX * 2];
	unsigned char add[IRC_MAX];

	bzero(buffer, sizeof(buffer));
        len = strlen((char *)src);

	for (i = 0, j = 0; i < len; i++) {
		if (src[i] < 0x80) {
			buffer[j] = src[i];
			j++;
			goto loop_end;
		}
		sum = src[i] << 8 | src[i+1];
		if ((phone_type == AU_EZWEB) && 
		    (sum >= 0xF340 && sum <= 0xF9FC)) {
			DPRINTF(1, ("AU emoji encode %04x\n", sum));
			for (k = 0; k < DAT_ROW; k++) {
			    if (emoji[k][AU_KEY] == sum) {
				sprintf(add, "emoji%03d ", emoji[k][DAT_NUM]);
				strncat(buffer, add, 9);
				j += 9;
				break;
			    }
			}
			i++;
		} else if (((phone_type == DOCOMO_PDC) ||
			    (phone_type == DOCOMO_FOMA)) &&
			   (sum >= 0xF89F && sum <= 0xF9FC)) {
			DPRINTF(1, ("found Docomo emoji %04x\n", sum));
			for (k = 0; k < DAT_ROW; k++) {
			    if (emoji[k][D_KEY] == sum) {
				sprintf(add, "emoji%03d ", emoji[k][DAT_NUM]);
				strncat(buffer, add, 9);
				j += 9;
				break;
			    }
			}
			i++;
		} else {
			buffer[j] = src[i];
			buffer[j + 1] = src[i + 1];
			i++;
			j += 2;
		}
loop_end:
	;;
	}
	buffer[j + 1] = '\0';

	DPRINTF(1, ("emoji encode:(%d)%s\n", j, buffer));
	strcpy(src, buffer);

	return j + 1;
}

int emoji_decode(unsigned char *src, int phone_type)
{
        int k, len, id;
	unsigned char *p, *q;
        char ids[4];
        unsigned char buffer[IRC_MAX * 2];
        unsigned char add[IRC_MAX * 2];

        bzero(buffer, sizeof(buffer));
        len = strlen((char *)src);

	if (phone_type == OTHER)
		return 0;

	q = src;
	p = src;
	while (p != NULL){
		if ((p = strstr(q, "emoji")) != NULL) {
			strncpy(ids, p + 5, 3);
			id = atoi(ids);

			if ((id > DAT_ROW) ||
			    !((src[p - src + 8] == 0x20) ||
			      (src[p - src + 8] == 0x0))) {
				strncat(buffer, q, (int)(p - q) + 5);
				q = p + 5;
				goto loop_end;
			}

			DPRINTF(1, ("emoji found ID:%03d, phone%d\n",
				id, phone_type));
			strncat(buffer, q, (int)(p - q));
			q = p + 9;

			for (k = 0; k < DAT_ROW; k++) {
			    if (emoji[k][DAT_NUM] == id) {
				if (phone_type == AU_EZWEB) {
				    DPRINTF(1, ("AU emoji found ID:%03d\n", id));
				    sprintf(add, "<img localsrc=\"%d\">",
					emoji[k][AU_STR]);
				    strcat(buffer, add);
				} else if (phone_type == DOCOMO_PDC) {
				    DPRINTF(1, ("PDC emoji found ID:%03d\n", id));
				    sprintf(add, "%c%c",
					(emoji[k][D_KEY]>>8) & 0x00FF,
					emoji[k][D_KEY] & 0x00FF);
				    strcat(buffer, add);
				} else if (phone_type == DOCOMO_FOMA) {
				    DPRINTF(1, ("FOMA emoji found ID:%03d\n", id));
				    sprintf(add, "&#x%04x;", emoji[k][D_STR]);
				    strcat(buffer, add);
				} else {
				    DPRINTF(1, ("cannot found out emoji ID:%03d\n", id));
				}
			    }
			}
			/* detect end of line */
			if (src[p - src + 8] == 0)
				break;
                } else {
			strncat(buffer, q, len - (int)(q - src));
                }
loop_end:
	;;
        }
	strcat(buffer, "\0");

        strcpy(src, buffer);

        return 0;
}

