/* $Id: check.c,v 1.12 2006/12/20 13:37:23 ichiro Exp $ */
/*
 * Copyright (c) 2004, 2005, 2006
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

extern int debug;

#include "kircd.h"

int version_check(struct tparam *th, char *version) {
	struct addrinfo h;
	int n, so;
	int get_val, own_val;
	char buf[1024];
	int ver_major, ver_minor1, ver_minor2;
	char *s;

	/* get own version */
	sscanf(version, "%d.%d.%d", &ver_major, &ver_minor1, &ver_minor2);
	own_val = (ver_major << 16) | (ver_minor1 << 8) | ver_minor2;

	/* make socket */
	char *host = VC_HOST;
	char *port = VC_PORT;
	bzero(&h, sizeof(h));
	h.ai_family = PF_UNSPEC;
	h.ai_socktype = SOCK_STREAM;
	so = get_addr(h, host, port, CLIENT);
	if (so < 0) {
		printf("error: faild to make socket for %s\n", VC_HOST);
		return (-2);
	}

	/* write "GET VC_URI HTTP/1.0" */
	bzero(buf, sizeof(buf));
	strcpy(buf, "GET ");
	strcat(buf, VC_URI);
	strcat(buf, " HTTP/1.0\r\n\r\n");
	send_postdata(so, buf);

	/* read socket */
	bzero(buf, sizeof(buf));
	if (read(so, buf, 1024) <= 0 ) {
		printf("error: reading socket for version_check()\n");
		return (-5);
	}
	s = strstr(buf, "AC_INIT");
	n = sscanf(s + 14, "%d.%d.%d%*[^\r\n]",
		&ver_major, &ver_minor1, &ver_minor2);
	if (n != 3)
		return (-3);

	/* convert version */
	get_val = (ver_major << 16) | (ver_minor1 << 8) | ver_minor2;
	DPRINTF(0, ("own_val=%x, get_val=%x\n", own_val, get_val));

	/* close socket */
	close(so);

	if ((get_val - own_val) > 0) {
		th->new_available = get_val;
		return (0);
	} else {
		th->new_available = 0;
		return (-4);
	}
}
