/* $Id: kircd.h,v 1.43 2006/01/02 23:40:23 ichiro Exp $ */
#define DEBUG
/*
 * Copyright (c) 2004, 2005, 2006
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef DEBUG
#define DPRINTF(n, x)	if (debug > (n)) printf x
#else
#define DPRINTF(n, x)
#endif

#if !HAVE_BZERO && HAVE_MEMSET
#define bzero(buf, bytes)  ((void)memset(buf, 0, bytes))
#endif

#include <glib/gthread.h>

#define CLIENT 0
#define SERVER 1

#define SBUFLEN 8192
#define LBUFLEN 8192
#define HTTPBUF 8192

#define CONFSEP ";\n"

/* GET /channel?? HTTP/1.1 */
/* GET/POST len 5 */
/* channel?? len 10 */
#define M_LEN 5
#define URI_LEN 10

/* channel */
#define CH_MAX 20
#define C_NAME 40

/* buffer lines per irc channel */
#define CHBUF_MAX 30

/* command length */
#define CMD_LEN 20

/* auth length(cookie) */
#define AUTH_LEN 64
#define CDATE_LEN 64

/* max cache line */
#define C_HISTORY_NUM 31

/* max length of nickname */
#define NAME_LEN 10

/* rfc1459, max length of IRC message is 512 byte */
#define IRC_MAX 600

/* subtopic length */
#define SUBTOPIC_LEN 20

/* CTCP */
static char ctcp_clientinfo[] = {
        "CLIENTINFO VERSION\r\n"
};

struct tparam {
	int socket_number;
	int server_socket;

	char real_nickname[40];

	/* recieve buffer */
	int s_read;
	int s_count;
	int s_empty;	/* recieve buffer empty */
	char *s_buff;
	char *l_buff;
	int s_lock;

	int max_line;
	int line_reverse;
	int show_topic;
	int cookie_expire;
	char name[CH_MAX][C_NAME];
	int  ch_count;
	char data[CH_MAX][C_HISTORY_NUM][IRC_MAX * 2];
	int  history_count[CH_MAX];
	int  read_count[CH_MAX];
	char topic[CH_MAX][IRC_MAX];
	char member_names[CH_MAX][IRC_MAX];
	int  member_count[CH_MAX];

	/* transfer buffer */
	int  t_empty;	/* trans buffer empty */
	int  t_lock;	/* trans buffer writing */
	char postdata[IRC_MAX * 2];

	/* auth (copy) */
	int  auth_method;
	char auth_user[AUTH_LEN];
	char auth_pass[AUTH_LEN];
	char uid[AUTH_LEN];
	int  auth_flag;
	int  regist_done;
	char user_agent[IRC_MAX * 2];

	/* send buffer */
	char *send_buf;
	int  send_buflen;

	/* timer */
	long last_access;
	int timeout;
};

struct config {
	char hostname[128];
	char server_port[40];
	char client_port[40];
	char password[40];
	char username[40];
	char nickname[40];

	/* auth */
	char auth_user[AUTH_LEN];
	char auth_pass[AUTH_LEN];
	int max_line;
	int line_reverse;
	int show_topic;
	int auth_method;
	int cookie_expire;

	/* timer */
	int timeout;
};

int main(int ac, char *av[]);
int get_addr(struct addrinfo, const char*, const char*, int);
void init(int, struct config *);
gpointer watch(gpointer);
gpointer lineget(gpointer);
extern gpointer httpd(gpointer);

extern int send_postdata(int, char *);
extern int send_msg(int, struct tparam *, char *);
extern void send_buf(struct tparam *, char *);
extern int readconf(unsigned char *, struct config *);
extern int keitai_start(struct tparam *);
extern int priv_recv(struct tparam *);
extern int topic_recv(struct tparam *);
extern int part_recv(struct tparam *);
extern int channel_delete(struct tparam *, char *);
extern int join_recv(struct tparam *);
extern int ctcp_recv(struct tparam *, char *, char *);
extern int channel_make(struct tparam *, char *);
extern int names_recv(struct tparam *);
extern int ping_recv(struct tparam *);
extern int send_names(struct tparam *, char *);
extern int nick_recv(struct tparam *);

extern int send_join(struct tparam *, char *);
extern int send_part(struct tparam *, char *);

extern int url_decode_jis(char *);
extern int decode_jis2sjis(char *);
extern int url_decode_rawdata(char *, char *);

extern int charconv(char *, size_t, const char *, size_t, const char *, const char *);
extern int channel_encode(char *, char *);
extern int channel_decode(char *, char *);
extern int ltgt_encode(char *, char *);
extern char * base64_decode(char *);
extern char * href_conv(char *);
extern int strcmp2(char *, char *);
extern int count_user(char *);
