/* $Id: auth.c,v 1.11 2006/01/04 02:30:47 ichiro Exp $ */
/*
 * Copyright (c) 2004, 2005, 2006
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

extern int debug;

#include "kircd.h"
#include "httpd.h"

void print_easybutton(struct tparam *);
char* find_uid(char *);
void get_time(struct tparam *);

int auth_proc(int socket, struct tparam *th2, char *buf, char *header)
{
	time_t timer;
	struct tm *date;

	char message[IRC_MAX];
	char base64[IRC_MAX * 2];
	char buffer[IRC_MAX * 2];
	char buffer2[IRC_MAX * 2];
	char web_user[AUTH_LEN], web_pass[AUTH_LEN];
	char cookie_user[AUTH_LEN], cookie_pass[AUTH_LEN];
	char date_str[CDATE_LEN];

	unsigned char *p, *q;

	/* bzero */
	bzero(message, sizeof(message));
	bzero(base64, sizeof(base64));
	bzero(buffer, sizeof(buffer));
	bzero(buffer2, sizeof(buffer2));

	/* get time */
	get_time(th2);

	/* get User-Agent */
	if ((p = strstr(buf, "User-Agent:")) != NULL) {
		strcpy(buffer, p + 12);
		sscanf(buffer, "%[^\r^\n]", buffer);

		/* DoCoMo */
		if ((p = strstr(buffer, "DoCoMo/1")) != NULL) {
			if ((q = strstr(p, "/ser")) != NULL) {
				strncat(buffer2, p, (int)(q - p));  
			DPRINTF(1, ("PDC User-Agent=%s\n", buffer2));
			} else {
				strcpy(buffer2, buffer);
			}
		} else if ((p = strstr(buffer, "DoCoMo/2")) != NULL) {
			if ((q = strstr(p, "(")) != NULL) {
				strncat(buffer2, p, (int)(q - p));
			DPRINTF(1, ("FOMA User-Agent=%s\n", buffer2));
			} else {
				strcpy(buffer2, buffer);
			}
		} else {
			strcpy(buffer2, buffer);
			DPRINTF(1, ("Other User-Agent=%s\n", buffer2));
		}

		/* initial check */
		if (strlen(th2->user_agent) == 0)
			strcpy(th2->user_agent, buffer2);

		if (th2->auth_flag &&
		    strcmp(buffer2, th2->user_agent) != 0 ) {
			DPRINTF(0, ("other browser access!\n"));
			th2->auth_flag = 0;
			DPRINTF(0, ("OLD(%d):%s\n",
				strlen(th2->user_agent), th2->user_agent));
			DPRINTF(0, ("NEW(%d):%s\n", strlen(buffer2), buffer2));
		} else {
			strcpy(th2->user_agent, buffer2);
		}
	}

	/* auth proc */
	if (th2->auth_method == 0 || th2->auth_method == 1) {
	    if (th2->auth_method == 1) { /* Cookie Authentication */
		if ((p = strstr(buf, "Cookie:")) != NULL) {
		    strcpy(base64, p + 8);
		    sscanf(base64, "%[^\r^\n]", base64);

		    if (sscanf(base64, "user=%[^;]; pass=%[^\r^\n]",
			cookie_user, cookie_pass) == 2);
		    else if (sscanf(base64, "pass=%[^;]; user=%[^\r^\n]",
			cookie_pass, cookie_user) == 2);
		    else
			DPRINTF(1, ("DEBUG: can not get cookie\n"));

		    DPRINTF(1, ("DEBUG: Cookie get.\n"));
		    DPRINTF(1, ("DEBUG: u:%s, p:%s\n", cookie_user, cookie_pass));
		}
	    }
	    /* Password Authentication */
	    if ((p = strstr(buf, "Authorization: Basic")) != NULL) {
		strcpy(base64, p + 21);
		sscanf(base64, "%[^\r^\n]", buffer);
		sscanf(base64_decode(buffer),
		       "%[^:]:%[^\n]", web_user, web_pass);
		DPRINTF(1, ("DEBUG: Passwd get.\n"));
		DPRINTF(1, ("DEBUG: u:%s, p:%s\n", web_user, web_pass));
	    }

	    /* Authentication */
	    DPRINTF(1, ("DEBUG: Authentication.\n"));
	    DPRINTF(1, ("DEBUG: u:%s, p:%s\n", th2->auth_user, th2->auth_pass));
	    if (th2->auth_method  == 1&&
		(strcmp(cookie_user, th2->auth_user) == 0) &&
		(strcmp(cookie_pass, th2->auth_pass) == 0)) {
		    DPRINTF(1, ("DEBUG: Cookie Authentication done.\n"));
	    } else if ((strcmp(web_user, th2->auth_user) == 0) &&
		       (strcmp(web_pass, th2->auth_pass) == 0)) {
		    DPRINTF(1, ("DEBUG: Passwd Authentication done.\n"));
		    if(th2->auth_method) {
			/* make cookie info */
			timer = time(NULL) + th2->cookie_expire * 24 * 60 * 60;
			date = gmtime(&timer);
			strftime(date_str, 255,
			         "%a, %d-%b-%Y %H:%M:%S GMT;\n", date);

			/* user */
			sprintf(message,
			        "Set-Cookie: user=%s; expires=", web_user);
			strcat(message, date_str);
			strcat(header, message);

			/* pass */
			sprintf(message,
			        "Set-Cookie: pass=%s; expires=",web_pass);
			strcat(message, date_str);
			strcat(header, message);
		    } /* USE_COOKIE */
	    } else {
			DPRINTF(1, ("DEBUG: cannot auth\n"));
			send_msg(socket, th2, http_auth_401_header);
			return -1;
	    }
	} else if (th2->auth_method == 2) { /* Easy Access */
	    if (!th2->auth_flag) {
		/* in first show easy auth page */
		DPRINTF(1, ("DEBUG: in first show easy auth page\n"));
		print_easybutton(th2);
		/* send data */
		send_msg(socket, th2, header);
		/* break */
		return -1;
	    }
	}
	return 0;
}

void print_easybutton(struct tparam *th2)
{
        send_buf(th2,
           "<form action=\"/regist\" method=\"post\" utn>");
        
        send_buf(th2, "Easy Access Registration<br>");
	if (!th2->regist_done) { /* show user/pass text box until regist */
		send_buf(th2,
		 "user<input type=\"text\" name=\"user2\" size=\"10\"><br>");
		send_buf(th2,
		 "pass<input type=\"password\" name=\"pass2\" size=\"10\"><br>");
	}
	send_buf(th2,
		 "<input type=\"submit\" value=\"EasyAccess\"></form>");
}

int easy_regist(int socket, struct tparam *th2, char *buf, char *header)
{
	int post_length;
	char web_user[AUTH_LEN], web_pass[AUTH_LEN];
	char uid[AUTH_LEN];
	char *s;
	char *buffer;

	/* init */
	bzero(web_user, sizeof(web_user));
	bzero(web_pass, sizeof(web_pass));
	bzero(uid, sizeof(uid));

	/* get UID */
	strcpy(uid, find_uid(buf));

	/* Get length of post data */
	if ((s = strstr(buf, "Content-Length: ")))
		post_length = atoi(s + 16);

	buffer = (char*)malloc(post_length + 1);
	if (buffer == NULL) return;
	*buffer = '\0';

	/* if cannot read post data , read more */
	if (!strstr(buf, "user2=")) {
		bzero(buf, sizeof(buf));
		read(socket, buf, post_length);
		DPRINTF(0, ("DEBUG:read more:%s\n", buf));
	}

	if ((s = strstr(buf, "user2="))) {
		sprintf(buffer, "%.*s", post_length, s);
		DPRINTF(0, ("DEBUG:auth data:%s\n", buffer));
	}

	s = strtok(buffer, "&");
	if (s != NULL) strcpy(web_user, s + 6);
	s = strtok(NULL, "&");
	if (s != NULL) strcpy(web_pass, s + 6);

	/* free */
	free(buffer);
	DPRINTF(0, ("DEBUG: user=%s, pass=%s\n", web_user, web_pass));

	/* regist UID */
	if (!th2->regist_done &&
	    (strcmp(web_user, th2->auth_user) == 0) &&
	    (strcmp(web_pass, th2->auth_pass) == 0)) {
		DPRINTF(0, ("DEBUG: regist done\n"));
		/* regist done */
		strcpy(th2->uid, uid);
		th2->regist_done = 1;
		/* authentication done */
		th2->auth_flag = 1;
		/* end */
		return 0;
	}
	/* compare UID */
	if (!strlen(th2->uid) ||
	    (strcmp(th2->uid, uid) == 0)) {
		DPRINTF(0, ("DEBUG: authentication done\n"));
		/* authentication done */
		th2->auth_flag = 1;
		/* end */
		return 0;  
	}

	DPRINTF(0, ("DEBUG: authentication failed\n"));
	return -1;
}

char* find_uid(char *buf)
{
	char *p, *uid;
	char buffer[IRC_MAX * 2];

	uid = buffer;
	*uid = '\0';

	if ((p = strstr(buf, "User-Agent: DoCoMo/1")) != NULL) {
		DPRINTF(1, ("DEBUG: Found out DoCoMo PDC\n"));
		if ((p = strstr(p + 12, "ser")) != NULL) {
			strcat(uid, p + 3);
			sscanf(uid, "%[^\r^\n]", uid);
		}
	}

	if ((p = strstr(buf, "User-Agent: DoCoMo/2")) != NULL) {
		DPRINTF(1, ("DEBUG: Found out DoCoMo FOMA\n"));
		if ((p = strstr(p + 12, "ser")) != NULL) {
			strncat(uid, p + 3, 15);
		}
	}

	if ((p = strstr(buf, "x-up-subno:")) != NULL) {
		DPRINTF(1, ("DEBUG: Found out AU x-up-subno\n"));
		strcat(uid, p + 12);
		sscanf(uid, "%[^\r^\n]", uid);
	}

	DPRINTF(1, ("DEBUG: UID:%s\n", uid));

	return uid;
}

void get_time(struct tparam *th2)
{
	time_t timer, diff;
	struct tm *date;
	char date_str[CDATE_LEN];

	if (!th2->last_access) {
		time(&timer);
		th2->last_access = timer;
	}
	/* make Last access time */
	date = gmtime(&th2->last_access); 
	strftime(date_str, 255, "%a, %d-%b-%Y %H:%M:%S GMT", date); 
	DPRINTF(1, ("DEBUG: Last Access Time: %s\n", date_str));
 
	/* update access time and calc time difference */
	time(&timer); 
	diff = timer - th2->last_access;
	th2->last_access = timer;
	date = gmtime(&th2->last_access);
	strftime(date_str, 255, "%a, %d-%b-%Y %H:%M:%S GMT", date); 
	DPRINTF(1, ("DEBUG: Now Access Time: %s\n", date_str));
	DPRINTF(1, ("DEBUG: Time diff(sec): %ld\n", diff));

	if (th2->auth_flag &&
	    (diff > 60 * th2->timeout)) {
		DPRINTF(1, ("DEBUG: Timeout!\n"));
		th2->auth_flag = 0;
	}

	return;
}
