/* $Id: keitai.c,v 1.41 2005/12/16 17:55:25 ichiro Exp $ */
/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/param.h>

#include "kircd.h"

int
keitai_start(struct tparam *th)
{
#ifdef DEBUG
		printf("%s\r\n", th->l_buff);
#endif
	/* skip NOTICE messages */
	if (strstr(th->l_buff, "NOTICE")) {
	}

	/* catch PING messages */
	if (strstr(th->l_buff, "PING"))
		ping_recv(th);

	/* catch NICK name */
	if (strstr(th->l_buff, "NICK"))
		nick_recv(th);

	/* detect JOIN channel */
	if (strstr(th->l_buff, "JOIN"))
		join_recv(th);

	if (strstr(th->l_buff, "PART"))
		part_recv(th);

	/* catch PRIVMSGs */
	if (strstr(th->l_buff, "PRIVMSG"))
		priv_recv(th);

	/* catch QUIT */
	if (strstr(th->l_buff, "QUIT")) {
#ifdef DEBUG
		printf("QUIT:%s\n", th->l_buff);
#endif
	}

	/* detect TOPIC */
	if (strstr(th->l_buff, "332") || strstr(th->l_buff, "TOPIC"))
		topic_recv(th);

	/* MODE */
	if (strstr(th->l_buff, "MODE")) {
#ifdef DEBUG
		printf("MODE:%s\n", th->l_buff);
#endif
	}

	/* NAMES */
	if (strstr(th->l_buff, "353"))
		names_recv(th);

	return (0);
}

int priv_recv(struct tparam *th)
{
	time_t t = time(NULL);
	struct tm* tm;
	char id[IRC_MAX];
	char channel[C_NAME], channel2[C_NAME];
	char message[IRC_MAX * 2];
	char message2[IRC_MAX * 2]; /* include &lt,&gt charactor */

	int n = 0;
	int ch_number = 255; /* 255 means "not found" */
	tm = localtime(&t);

	/* zero clear */
	bzero(channel,  sizeof(channel));
	bzero(channel2, sizeof(channel2));
	bzero(message,  sizeof(message));
	bzero(message2, sizeof(message2));

	/* get PRIVMSG */
	n = sscanf(th->l_buff, ":%[^!]!%*s PRIVMSG %s :%[^\n]",
			id, channel, message);
	if (n < 3) { /* for madoka4.2 */
		n = sscanf(th->l_buff, ":%s PRIVMSG %s :%[^\n]",
			id, channel, message);
	}

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

	/* message; '<','>' ---> '&lt;','&gt;' */
        ltgt_encode(message2, message);

	/* add href tag */
	href_conv(message2);

#ifdef DEBUG 
	printf("%s | <%s> %s\n", channel2, id, message2);
#endif

	for (n = 0; n <= th->ch_count; n++) {
		if (strcmp2(th->name[n], channel2) == 0) {
					/* message to channel */
			ch_number = n;
			break;
		} else if (strcmp2(th->name[n], id) == 0) { 
					/* message from another person */
			ch_number = n;
			break;
		}
	}
	/* can not found out channel, maybe conversation
	   with another person ? */
	if (ch_number == 255) {
		if (strcmp2(th->real_nickname, channel2) == 0) {
			ch_number = channel_make(th, id);
#ifdef DEBUG
			printf("make new channel with %s\n", id);
#endif
		} else {
#ifdef DEBUG
			printf("channel not found(%s)\n", channel2);
#endif
			return (1);
		}
	} 

	/* check history count and roll up */
	if (th->history_count[ch_number] == th->max_line) {
		for (n = 0; n <= th->max_line; n++) {
			strcpy(th->data[ch_number][n],
			       th->data[ch_number][n + 1]);
			bzero(th->data[ch_number][n + 1],
			       sizeof(th->data[ch_number][n + 1]));
		}
		th->history_count[ch_number]--;
		if (th->read_count[ch_number] > 0)
			th->read_count[ch_number]--;
	}

	/* add message with time into historical buffer */
	if (strcmp2(th->real_nickname, id) == 0) { /* own messages */
		sprintf(th->
			data[ch_number][th->history_count[ch_number]],
			"%02d:%02d &gt;%s&lt;  %s<br>",
			tm->tm_hour, tm->tm_min,id, message2);
		th->read_count[ch_number]++;
	} else {
		sprintf(th->
			data[ch_number][th->history_count[ch_number]],
			"%02d:%02d &lt;%s&gt; %s<br>",
			tm->tm_hour, tm->tm_min,id, message2);
	}
	th->history_count[ch_number]++;

#ifdef DEBUG
	printf("%d: %s | %s\n", (th->history_count[ch_number] - 1), channel2,
		th->data[ch_number][th->history_count[ch_number] - 1]);
#endif

	return (0);
}

int names_recv(struct tparam *th)
{
	int n = 0;
	char id[IRC_MAX];
	char channel[C_NAME], channel2[C_NAME];
	char names[IRC_MAX];

	/* get NAMES */
	if ((sscanf(th->l_buff, ":%*s 353 %s %*s %s :%[^\n]",
		id, channel, names)) != 3)
		return (1);

	if (strcmp2(th->real_nickname, id) != 0)
		return (0);

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

#ifdef DEBUG
	printf("NAMES:channel=%s, names=%s\n", channel2, names);
#endif

	for (n = 0; n <= th->ch_count; n++) {
		if (strcmp2(th->name[n], channel2) == 0)
                        sprintf(th->member_names[n], " %s", names);
        }

	return (0);
}

int topic_recv(struct tparam *th)
{
	int n = 0;
	char topic[IRC_MAX * 2], buf[IRC_MAX * 2];
	char channel[C_NAME], channel2[C_NAME];

	/* zero clear */
	bzero(buf, sizeof(buf));
	bzero(channel, sizeof(channel));
	bzero(channel2, sizeof(channel2));

	/* get TOPIC */
	if (strstr(th->l_buff, "332")) {
		if ((sscanf(th->l_buff, ":%*s 332 %*s %s :%[^\n]",
			channel, topic)) != 2)
			return (1);
	} else if (strstr(th->l_buff, "TOPIC")) {
		if ((sscanf(th->l_buff, ":%*s TOPIC %s :%[^\n]",
			channel, topic)) != 2)
			return (1);
	}

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

#ifdef DEBUG
	printf("TOPIC:channel=%s, topic=%s\n", channel2, topic);
#endif
	/* '<','>' ---> '&lt;','&gt;' */
	ltgt_encode(buf, topic);

	/* add href tag */
	href_conv(buf);

	for (n = 0; n <= th->ch_count; n++) {
		if (strcmp2(th->name[n], channel2) == 0)
			sprintf(th->topic[n], " %s", buf);
	}
	return (0);
}

int part_recv(struct tparam *th)
{
	char id[IRC_MAX];
	char channel[C_NAME], channel2[C_NAME];

	/* zero clear */
	bzero(channel,  sizeof(channel));
	bzero(channel2, sizeof(channel2));

	/* get PART */
	if (sscanf(th->l_buff, ":%[^!]!%*s PART %s :%*[^,]",
		id, channel) == 2) {
		if (strcmp2(th->real_nickname, id) != 0) {
		   /* send NAMES command */
		   send_names(th, channel);
		   return (0);
		}
	} else if (sscanf(th->l_buff, ":%s PART %s :%*[^,]",
		id, channel) == 2) {
		if (strcmp2(th->real_nickname, id) != 0) {
			return (0);
		}
	}

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

	/* delete channel */
	channel_delete(th, channel2);

	return (0);
}

int channel_delete(struct tparam *th, char *channel)
{
	int i, j, match = 255;

	 /* search exist channel */
	for (i = 0; i <= th->ch_count; i++) {
		if (strcmp2(th->name[i], channel) == 0) {
			match = i;
			break;
		}
	}

	if (match > th->ch_count)
		return (0);

	if (match == th->ch_count) {
		bzero(th->name[match], sizeof(th->name[match]));
		bzero(th->topic[match], sizeof(th->topic[match]));
		bzero(th->member_names[match], sizeof(th->member_names[match]));
		bzero(th->data[match], sizeof(th->data[match]));
		th->history_count[match] = 0;
		th->read_count[match] = 0;
	} else {
	    for (i = match; i < th->ch_count; i++) {
		bzero(th->name[i], sizeof(th->name[i]));
		bzero(th->topic[i], sizeof(th->topic[i]));
		bzero(th->member_names[i], sizeof(th->member_names[i]));
		bzero(th->data[i], sizeof(th->data[i]));

		strcpy(th->name[i], th->name[i + 1]);
		strcpy(th->topic[i], th->topic[i + 1]);
		strcpy(th->member_names[i], th->member_names[i + 1]);

		for (j = 0; j < th->history_count[i + 1]; j++) {
			strcpy(th->data[i][j], th->data[i + 1][j]);
		}
		th->history_count[i] = th->history_count[i + 1];
		th->read_count[i] = th->read_count[i + 1];
	    }
	    bzero(th->name[th->ch_count],
		   sizeof(th->name[th->ch_count]));
	    bzero(th->topic[th->ch_count],
		   sizeof(th->topic[th->ch_count]));
	    bzero(th->member_names[th->ch_count],
		   sizeof(th->member_names[th->ch_count]));
	    bzero(th->data[th->ch_count],
		   sizeof(th->data[match]));
	    th->history_count[th->ch_count] = 0;
	    th->read_count[th->ch_count] = 0;
	}
	th->ch_count--;

#ifdef DEBUG
	printf("part channel name(%d) = %s\n", th->ch_count, channel);
#endif

	return (0);
}

int join_recv(struct tparam *th)
{
	int i;
	char id[IRC_MAX];
	char channel[C_NAME], channel2[C_NAME];

	/* zero clear */
	bzero(channel, sizeof(channel));
	bzero(channel2, sizeof(channel2));

	/* get JOIN */
	if (strstr(th->l_buff, "JOIN")) {
		if (sscanf(th->l_buff, ":%[^!]!%*s JOIN :%[^,]",
			   id, channel) == 2);
		else if (sscanf(th->l_buff, ":%[^!]!%*s JOIN %[^,]",
				id, channel) == 2);
		else if (sscanf(th->l_buff, ":%s JOIN %[^,]",
				id, channel) == 2);

		if (strcmp2(th->real_nickname, id) == 0) {
			/* channel;  #hoge:*.jp -> %hoge */
			channel_encode(channel2, channel);
			/* search exist channel */
			for (i = 0; i <= th->ch_count; i++) {
				if (strcmp2(th->name[i], channel) == 0) {
#ifdef DEBUG
					printf("channel exist!\n");
#endif
					return (0);
				}
			}
			/* make new channel */
			channel_make(th, channel2);
                } else {
			/* send NAMES command */
                        send_names(th, channel);
                }
        }

	return (0);
}

int channel_make(struct tparam *th, char *channel)
{
	int i, n = 0;

	/* make new channel */
	while (th->name[n][0] != '\0')
		n++;
	if (n > th->ch_count)
		th->ch_count = n; /* largest channel number */

	strcpy(th->name[n], channel);

#ifdef DEBUG
	printf("join channel name(%d) = %s\n", n, th->name[n]);
#endif
	return (n);
}

int ping_recv (struct tparam *th)
{
	char server[IRC_MAX], data[IRC_MAX];

	/* zero clear */
	bzero(server,  sizeof(server));

	/* get PING */
	sscanf(th->l_buff, "PING :%[^\n]", server);

	/* transfer message */
	sprintf(data, "PONG %s\r\n", server);
#ifdef DEBUG
	printf("PING:sent data\n");
#endif
	send_postdata(th->socket_number, data);

	return (0);
}

int nick_recv(struct tparam *th)
{
	char old_nickname[NAME_LEN];
	char new_nickname[NAME_LEN];

	sscanf(th->l_buff, ":%[^!]!%*s NICK :%[^,]",
		old_nickname, new_nickname);

	if (strcmp2(th->real_nickname, old_nickname) == 0) {
		strcpy(th->real_nickname, new_nickname);
#ifdef DEBUG
	printf("NICK:%s -> %s\n", old_nickname, th->real_nickname);
#endif
	}

	return (0);
}

int send_names(struct tparam *th, char *channel)
{
	char data[IRC_MAX];

	sprintf(data, "NAMES %s\r\n", channel);

#ifdef DEBUG
	printf("NAMES:sent data\n");
#endif
	send_postdata(th->socket_number, data);

	return (0);
}
