/* $Id: httpd.c,v 1.43 2005/12/16 17:55:25 ichiro Exp $ */
/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

#include "kircd.h"
#include "httpd.h"

void httpd_proc(struct tparam *, int);
void print_command_page(struct tparam *, int);

gpointer
httpd(gpointer param)
{
	struct tparam *th2;
	int s2, s3;

	th2 = (struct tparam *)param;
	s2 = th2->server_socket;

	for (;;) {
		s3 = accept(s2, NULL, NULL);
		if (s3 < 0) {
			printf("error: accepting a socket.\n");
			exit (1);
		}
		usleep(100000);
		httpd_proc(th2, s3);

		close(s3);
	}
}

void httpd_proc(struct tparam *th2, int socket)
{
	time_t timer;
	struct tm *date;
	
	char buf[SBUFLEN];
	char meth_name[64];
	char channel[C_NAME], channel2[C_NAME];
	char uri_addr[64];
	char base64[HTTPBUF];
	char basic_auth[HTTPBUF];
	char header[HTTPBUF];
	char message[HTTPBUF];
	char post_message[HTTPBUF + 256]; /* include url_encode mergin */
	char post_message2[HTTPBUF + 256];
	char web_user[64], web_pass[64];
	char cookie_user[64], cookie_pass[64], date_str[40];
	char *s, *q;
	char cmd_cname[C_NAME], cmd_cmd[20], cmd_topic[IRC_MAX];
	char cmd_buf[IRC_MAX];

	int n = 0;
	int r_fd = 0;
	char http_ver[4];

	int number = 0;
	int update = 0;
	int start_number = 0;
	int post_length = 0;
	int post_ch_number = 0;

	unsigned char *p;

	/* bzero */
	bzero(buf, sizeof(buf));
	bzero(meth_name, sizeof(meth_name));
	bzero(uri_addr, sizeof(uri_addr));
	bzero(base64, sizeof(base64));
	bzero(basic_auth, sizeof(basic_auth));
	bzero(message, sizeof(message));
	bzero(channel, sizeof(channel));
	bzero(channel2, sizeof(channel2));
	bzero(post_message, sizeof(post_message));
	bzero(post_message2, sizeof(post_message2));
	bzero(th2->postdata, sizeof(th2->postdata));

	bzero(cmd_cname, sizeof(cmd_cname));
	bzero(cmd_cmd, sizeof(cmd_cmd));
	bzero(cmd_topic, sizeof(cmd_topic));
	bzero(cmd_buf, sizeof(cmd_buf));

	if (read(socket, buf, SBUFLEN) <= 0 ) {
		printf("error: reading a request.\n");
		return;
	}

	if ((sscanf(buf, "%s %s HTTP/%s\n",
			meth_name, uri_addr, http_ver)) < 3) {
		printf("error: catch strings of request.\n");
	}
#ifdef DEBUG
	printf("HTTP(DEBUG):meth_name= %s\n", meth_name);
	printf("HTTP(DEBUG):uri_addr= %s\n", uri_addr);
	printf("HTTP(DEBUG):http_ver= %s\n", http_ver);
	printf("---------------------------\n");
	printf("BUF(DEBUG):%s\n", buf);

#endif
	/* Use cookie ? */
	if (th2->use_cookie) {
	   /* Cookie Authentication */
	   if ((p = strstr(buf, "Cookie:")) != NULL) {
		strcpy(base64, p + 8);
#ifdef DEBUG2
	printf("DEBUG: Cookie get.\n");
#endif

		if (sscanf(base64, "user=%[^;]; pass=%[^\r^\n]",
		    cookie_user, cookie_pass) == 2);
		else if (sscanf(base64, "pass=%[^;]; user=%[^\r^\n]",
			 cookie_pass, cookie_user) == 2);
		else
			printf("DEBUG:error\n");
	    }
	} /* Use cookie */

	/* Password Authentication */
	if ((p = strstr(buf, "Authorization: Basic")) != NULL) {
#ifdef DEBUG2
	printf("DEBUG: Passwd get.\n");
#endif
		strcpy(base64, p + 21);
		sscanf(base64, "%[^\r^\n]", basic_auth);
		sscanf(base64_decode(basic_auth),
		       "%[^:]:%[^\n]", web_user, web_pass);
	}

	if (th2->use_cookie &&
	   (strcmp(cookie_user, th2->auth_user) == 0) &&
	   (strcmp(cookie_pass, th2->auth_pass) == 0)) {
#ifdef DEBUG2
	printf("DEBUG: Cookie Authentication done.\n");
#endif
		/* copy header */
		strcpy(header, http_header0);
	} else if ((strcmp(web_user, th2->auth_user) == 0) &&
		   (strcmp(web_pass, th2->auth_pass) == 0)) {
#ifdef DEBUG2
	printf("DEBUG: Passwd Authentication done.\n");
#endif
		/* copy header */
		strcpy(header, http_header0);

		/* make cookie info */
		timer = time(NULL) + th2->cookie_expire * 24 * 60 * 60;
		date = gmtime(&timer);
		strftime(date_str, 255, "%a, %d-%b-%Y %H:%M:%S GMT;\n", date);

		/* user */
		sprintf(message, "Set-Cookie: user=%s; expires=", web_user);
		strcat(message, date_str);
		strcat(header, message);

		/* pass */
		sprintf(message, "Set-Cookie: pass=%s; expires=",web_pass);
		strcat(message, date_str);
		strcat(header, message);
	} else {
		/* cannot auth */
		send_msg(socket, th2, http_auth_401_header);
		return;
	}

	/* check and clear auth info */
	bzero(web_user, sizeof(web_user));
	bzero(web_pass, sizeof(web_pass));
	bzero(cookie_user, sizeof(cookie_user));
	bzero(cookie_pass, sizeof(cookie_pass));

	/* POST session */
	if ((strcmp(meth_name, "POST")) == 0) {
#ifdef DEBUG
		printf("status: POST Session\n");
#endif
		/* wait for flags clear */
		while ((!th2->t_empty) || (th2->t_lock)) {
			usleep(10000); /* 10ms */
		}
		th2->t_lock = 1;	/* now writing */

		/* Get length of post data */
		if ((s = strstr(buf, "Content-Length: ")))
			post_length = atoi(s + 16);

		/* if cannot read 'm=' or 'cname=', read more */
		if((!strstr(buf, "m=")) && (!strstr(buf, "cname="))) {
			/* zero clear buffer */
			bzero(buf, sizeof(buf));
			read(socket, buf, post_length);
#ifdef DEBUG
			printf("%s\n", buf);
#endif
		}

		/* Get post message */
		if ((s = strstr(buf, "m="))) {
			sprintf(post_message, "%.*s",
				post_length - 2, s + 2);

			if (post_length < 3) {
				/* clear trans. empty flag */
				th2->t_empty = 0;
                                th2->t_lock = 0;
                                goto index_start;
			}

			/* URL decord */
			url_decode_jis(post_message2, post_message);
#ifdef DEBUG
			printf("decode: %s\n", post_message);
#endif

			/* Get channel number to post */
			sscanf(uri_addr + 1, "channel%d",
				&post_ch_number);

			/* channel decode (%hoge -> #hoge:*.jp) */
			channel_decode(channel2,
					th2->name[post_ch_number]);

			/* transfer message to data buffer */
			sprintf(th2->postdata,
				":%s PRIVMSG %s :%s\r\n",
				 th2->real_nickname, channel2,
				 post_message2);

			/* store own messages */
			strcpy(th2->l_buff, th2->postdata);
			priv_recv(th2);
			bzero(th2->l_buff, sizeof(th2->l_buff));

			/* show only own throw message */
			update = 1;
			th2->read_count[post_ch_number]--;

			/* clear trans. empty flag */
			th2->t_empty = 0;
			th2->t_lock = 0;

		} else if ((s = strstr(buf, "cname="))) {
			/* clear buffer */
			bzero(cmd_cname, sizeof(cmd_cname));        
			bzero(cmd_cmd, sizeof(cmd_cmd));    
			bzero(cmd_topic, sizeof(cmd_topic));

			if (post_length < 22) {
				/* clear trans. empty flag */
				th2->t_empty = 0;
                                th2->t_lock = 0;
                                goto index_start;
			}

			sprintf(post_message,	/* XXX temporary used */
				"%.*s", post_length, s);

			/* cname=&cname2=&cmd=part&topic= */
			q = strtok(post_message, "&");
			if (q != NULL) strcpy(cmd_cname, q + 6);
							/* 6: cname= */

			q = strtok(NULL, "&");
			if (q != NULL) {
				if (strlen(cmd_cname) == 0)
					strcpy(cmd_cname, q + 7);
							/* 7: cname2= */
			}

			q = strtok(NULL, "&");
			if (q != NULL) {
				strcpy(cmd_cmd, q + 4);	/* 4: cmd= */
			}

			q = strtok(NULL, "&");
			if (q != NULL) {
				strcpy(cmd_buf, q + 6); /* 6: topic= */
			}
#ifdef DEBUG
			printf("cname=%s\ncmd=%s\ntopic=%s\n",
				cmd_cname, cmd_cmd, cmd_buf);
#endif
			/* make command message */
			if (strcmp(cmd_cmd, "join") == 0) {
			   if(strlen(cmd_cname) > 0){
				url_decode_rawdata(channel, cmd_cname);
				/* send join */
				send_join(th2, channel);
			   }
			} else if (strcmp(cmd_cmd, "part") == 0) {
			   if(strlen(cmd_cname) > 0){
				url_decode_rawdata(channel, cmd_cname);
				/* send part */
				send_part(th2, channel);
			   }
			} else if (strcmp(cmd_cmd, "nick") == 0) {
			   if(strlen(cmd_buf) > 0){
				sprintf(th2->postdata, ":%s NICK %s\r\n",
					th2->real_nickname, cmd_buf);
			   }
			} else if (strcmp(cmd_cmd, "topic") == 0) {
			   if((strlen(cmd_cname) > 0) &&
				(strlen(cmd_buf) > 0)){
				url_decode_rawdata(channel, cmd_cname);
				/* any -> #hoge*.jp */
				channel_decode(channel2, channel);
				url_decode_jis(cmd_topic, cmd_buf);
				sprintf(th2->postdata, ":%s TOPIC %s :%s\r\n",
					th2->real_nickname,
					channel2, cmd_topic);
			   }
			} else {
				goto command_start;
			}
		}

		/* clear trans lock and empty flag */
		th2->t_empty = 0;
		th2->t_lock = 0;
	}	/* POST */

#if 0
	/* favicon.ico */
	if (strstr(uri_addr + 1, "favicon.ico")) {
#ifdef DEBUG
		printf("favicon session\n");
#endif
		if ((r_fd = open(uri_addr, O_RDONLY,
				 0666)) == -1) {
			printf("favicon.ico file not found\n");
		} else if (strcmp(http_ver,"1.0") == 0) {
			send_msg(socket, ico_header10);
			while((n = read(r_fd, buf, HTTPBUF)) > 0) {
			   if (write(socket, buf, n) != n) {
			   	printf("error: writing a file\n");
				break;
			   }
			} /* while */
		} else if (strcmp(http_ver,"1.1") == 0) {
			printf("ver 1.1\n");

		}

		close(r_fd);
		send_msg(socket, http_footer);
	} /* favicon.ico */
#endif

	/* start COMMAND page */
command_start:
	if ((strcmp(uri_addr + 1, "cmd") == 0) &&
	    (strcmp(meth_name, "GET") == 0)) {
#ifdef DEBUG
		printf("COMMAND page\n");
#endif
		print_command_page(th2, socket);

		/* send data */
		send_msg(socket, th2, header);

		return;
	}

index_start:
	/* start index of each channels */
	if ((sscanf(uri_addr + 1, "channel%d", &number)) == 1) {
#ifdef DEBUG
		printf("Sub index session\n");
#endif
		/* check update or not */
		if (number >= 50) {
			update = 1;
			number -= 50;
		}

		/* print TOPIC */
		if (strlen(th2->topic[number]) > 0) {
			sprintf(message, "$B$H$T$/(B :%s<br>",
				th2->topic[number]);
			send_buf(th2, message);
		}

		/* print NAMES */
		if (strlen(th2->member_names[number]) > 0) {
			sprintf(message, "users:%s<br>",
				th2->member_names[number]);
			send_buf(th2, message);
		}

		/* print FORM */
		sprintf(message,
			"<form action=\"/channel%d\" method=\"post\">", number);
		send_buf(th2, message);
		send_buf(th2,
			 "<input type=text name=\"m\" size=\"10\">");
		send_buf(th2,
			 "<input type=submit value=\" $BAw?.(B \"></form>");
		send_buf(th2,
			"<a accesskey=\"8\" href=\"/\">back[8]</a><hr>");

		if (update)
			start_number = th2->read_count[number];
		else
			start_number = 0;

		if (th2->line_reverse) {
			for (n = start_number;
			     n < th2->history_count[number]; n++) {
				sprintf(message, "%s",
					th2->data[number][n]);
				send_buf(th2, message);
			}
		} else {
			for (n = th2->history_count[number] - 1;
			     n >= start_number; n--) {
				sprintf(message, "%s",
					th2->data[number][n]);
				send_buf(th2, message);
			}
		}
		th2->read_count[number] = th2->history_count[number];

		send_msg(socket, th2, header);

		update = 0;

		return;
	}

	/* start main index */
#ifdef DEBUG
	printf("start main index\n");
#endif
	for (n = 0; n <= th2->ch_count; n++) {
	    if (n < 9) {
	       sprintf(message,
		   "%d <a accesskey=\"%d\" href=\"channel%d\">%s</a>"
		   "<a href=\"channel%d\">(%d)</a><br>",
		    n, n, n, th2->name[n],
		    n + 50, th2->history_count[n] -
		    th2->read_count[n]);
	    } else {
	sprintf(message,
		   "* <a href=\"channel%d\">%s</a>"
		   "<a href=\"channel%d\">(%d)</a><br>",
		    n, th2->name[n],
		    n + 50, th2->history_count[n] -
		    th2->read_count[n]); 	
	    }
		send_buf(th2, message);
	}
	sprintf(message,
		"<hr>9 <a accesskey=9 href=\"cmd\">"
		"command page[9]</a><br>");
	send_buf(th2, message);
	sprintf(message,
		"<br><left>kircd Ver %s </left>", VERSION);
	send_buf(th2, message);

	send_msg(socket, th2, header);

	return;
}

void send_buf(struct tparam *th, char *addmsg)
{
	int buf_len, add_len;

	buf_len = strlen(th->send_buf);
	add_len = strlen(addmsg);

	if (th->send_buflen < (buf_len + add_len + 1)) {
#ifdef DEBUG
		printf("SEND_BUF %d -> ", th->send_buf); 
#endif
		th->send_buflen = th->send_buflen + HTTPBUF;
		th->send_buf = (char *)realloc(th->send_buf,
				th->send_buflen);
#ifdef DEBUG
		printf("%d\n", th->send_buf); 
#endif
	}

	strcat(th->send_buf, addmsg);
}

int send_msg(int fd, struct tparam *th, char *header_msg)
{
	int n;
	int header_len, msg_len, footer_len, total_len;
	int buffer_len;
	char contentlen[30];
	char *buffer;

	header_len = strlen(http_header1);
	msg_len    = strlen(th->send_buf);
	footer_len = strlen(http_footer);

	total_len  = header_len + msg_len + footer_len;

	/* make Content-Length */
	sprintf(contentlen,
		"Content-Length: %d\r\n\r\n", total_len);

	/* memory allocate */
	buffer = (char*)malloc(total_len + 1);
	*buffer = '\0';

#ifdef DEBUG
	printf("send_msg: length = %d\r\n\r\n",
		header_len + msg_len + footer_len);
#endif
	/* copy control header */
	strcat(buffer, header_msg);
	strcat(buffer, http_contype);
	strcat(buffer, contentlen);

	/* copy html header */
	strcat(buffer, http_header1);

	/* copy message */
	strcat(buffer, th->send_buf);

	/* copy footer */
	strcat(buffer, http_footer);

	buffer_len = strlen(buffer);

#ifdef DEBUG
	printf("SEND_DATA:(%d)byte\n%s\n", buffer_len, buffer);
#endif

	if (write(fd, buffer, buffer_len) != buffer_len){
		printf("error: writing %d chars\n", buffer_len);
	}

	/* clear buffer */
	strcpy(th->send_buf, "\0");

	/* free buffer */
	free(buffer);

	return buffer_len;
}

void print_command_page(struct tparam *th2, int socket)
{
	char str[C_NAME];
	int i;

	send_buf(th2,
	   "<form action=\"/cmd\" method=\"post\">");
	
	send_buf(th2, "Channel:");
	send_buf(th2,
	   "<br><select name=\"cname\">");
	send_buf(th2,
	   "<option value=\"\">specific</option>");
	for (i = 0; i < th2->ch_count + 1; i++) {
		sprintf(str, "<option value=\"%s\">%s</option>",
			th2->name[i], th2->name[i]);
		send_buf(th2, str);
	}
	send_buf(th2, "</select>");

	send_buf(th2,
	   "<br><input type=text name=\"cname2\" size=\"17\">");

	send_buf(th2,
	   "<br><input type=radio name=\"cmd\" value=\"part\">PART");
	send_buf(th2,
	   "<input type=radio name=\"cmd\" value=\"join\">JOIN");

	send_buf(th2,
	   "<hr><input type=radio name=\"cmd\" value=\"topic\">TOPIC");
	send_buf(th2,
	   "<input type=radio name=\"cmd\" value=\"nick\">NICK");
	send_buf(th2,
	   "<br><input type=text name=\"topic\" size=\"17\">");

	send_buf(th2,
	   "<hr><input type=submit value=\" $BAw?.(B [1]\">");
	send_buf(th2,
	   "<a accesskey=\"8\" href=\"/\"> back[8]</a></form>");
}

int send_join(struct tparam *th, char *channel)
{
	int i;
	char channel2[C_NAME];

	/* any ->%hoge */
	channel_encode(channel2, channel);

	/* search exist channel */
	for (i = 0; i <= th->ch_count; i++) {
		if (strcmp2(th->name[i], channel2) == 0) {
#ifdef DEBUG
			printf("channel exist!\n");
#endif
			return (0);
		}
	}

	/* %hoge -> #hoge*.jp */
	channel_decode(channel2, channel);

	if (channel2[0] == '#') { /* make channel */
		sprintf(th->postdata, ":%s JOIN %s\r\n",
			th->real_nickname, channel2);
	} else {			/* make channel with person */
		/* make new channel */
		channel_make(th, channel2);
	}

	return (0);

}

int send_part(struct tparam *th, char *channel)
{
	char channel2[C_NAME];

	/* any -> #hoge*.jp */
	channel_decode(channel2, channel);

	if (channel2[0] == '#') {	/* disconnect from irc-channel */
		sprintf(th->postdata, ":%s PART %s\r\n",
			th->real_nickname, channel2);
	} else {			/* disconnect from person */
		/* delete channel */
		channel_delete(th, channel2);
	}

	return (0);
}
