/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.graphics;

import java.awt.Color;
import kinugasa.object.Model;
import kinugasa.object.Statable;

/**
 * FARGB̊evf̑JڃASY`܂.
 * <br>
 * Fvf0255̐Ƃĕ\܂B
 * 1̐F́ARGBRGBAColorTransitionModel\܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/12_18:59:50<br>
 * @author Dra0211<br>
 */
public abstract class ColorTransitionModel extends Model implements Statable {

	private static final long serialVersionUID = -5301732826729025440L;
	/** JE^ƂĎgp\ȍŏ̒l(0)ł. */
	public static final int MIN = 0;
	/** JE^ƂĎgp\ȍő̒l(255)ł. */
	public static final int MAX = 255;
	/** ݂̒lł. */
	protected int value;

	/**
	 * lw肵āAJڃASY`܂.
	 * @param value ̃f\Fvf̏lw肵܂B<br>
	 * @throws IllegalArgumentException lFvfƂėLȒlłȂƂɓ܂B<br>
	 */
	public ColorTransitionModel(int value) throws IllegalArgumentException {
		if (value < 0 || value > 255) {
			throw new IllegalArgumentException("illegal color value : value=[" + value + "]");
		}
		this.value = value;
	}

	//JEgȂŒJE^ԂB̖߂lStaableƂĂ͏IȂ
	/**
	 * lύXȂASY쐬܂.
	 * @param value Fvf̒lw肵܂B<br>
	 * @return w肵Fvf̒lύXȂfԂ܂B<br>
	 * @throws IllegalArgumentException lFvfƂėLȒlłȂƂɓ܂B<br>
	 */
	public static ColorTransitionModel valueOf(int value) throws IllegalArgumentException {
		return new ColorTransitionModel(value) {
			private static final long serialVersionUID = 8593451345811759766L;

			@Override
			public void update() {
			}

			@Override
			public boolean isEnded() {
				return true;
			}

			@Override
			public boolean isRunning() {
				return true;
			}
		};
	}

	@Override
	public abstract boolean isEnded();

	@Override
	public abstract boolean isRunning();

	/**
	 * ̃ASYɂāAl(value)ύX܂.
	 * lAL͈(0-255)oꍇAL͈͓ɐ؂l߂Kv܂B<br>
	 * ܂AJnяIԂ̕ύXsKv܂B<br>
	 */
	public abstract void update();

	/**
	 * ľݒl擾܂.
	 * ̃\bhɂĕԂĺAupdateĂ΂܂
	 * ύXĂ͂Ȃ܂B<br>
	 * @return ݒlԂ܂B<br>
	 */
	public int getValue() {
		return value;
	}

	/**
	 * lݒ肷.
	 * @param value Vl𑗐M܂B0ȏ255ȉw肵܂B<br
	 * @throws IllegalArgumentException lFvfƂėLȒlłȂƂɓ܂B<br>
	 */
	public void setValue(int value) throws IllegalArgumentException {
		if (value < 0 || value > 255) {
			throw new IllegalArgumentException("illegal color value : value=[" + value + "]");
		}
		this.value = value;
	}

	/**
	 * RGB̑JڃASY݂̌̒lgpāAF\z܂.
	 * @param r ԗvf̃ASYłB<br>
	 * @param g ΂̃ASYłB<br>
	 * @param b f̃ASYłB<br>
	 * @return w肳ꂽASY݂̌̒l\zꂽFԂ܂BAt@255ƂȂ܂B<br>
	 */
	public static Color createColor(ColorTransitionModel r,
			ColorTransitionModel g,
			ColorTransitionModel b) {
		return new Color(r.value, g.value, b.value);
	}

	/**
	 * RGBAJڃASY݂̌̒lgpāAF\z܂.
	 * @param r ԗvf̃ASYłB<br>
	 * @param g ΂̃ASYłB<br>
	 * @param b f̃ASYłB<br>
	 * @param a At@̃ASYłB<br>
	 * @return w肳ꂽASY݂̌̒l\zꂽFԂ܂B<br>
	 */
	public static Color createColor(ColorTransitionModel r,
			ColorTransitionModel g,
			ColorTransitionModel b,
			ColorTransitionModel a) {
		return new Color(r.value, g.value, b.value, a.value);
	}

	@Override
	public ColorTransitionModel clone() {
		return (ColorTransitionModel) super.clone();
	}

	@Override
	public int hashCode() {
		int hash = 3;
		hash = 19 * hash + this.value;
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final ColorTransitionModel other = (ColorTransitionModel) obj;
		if (this.value != other.value) {
			return false;
		}
		return true;
	}

	@Override
	public String toString() {
		return "ColorCounter{" + "value=" + value + '}';
	}
}
