/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.rpgui;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kinugasa.resource.DuplicateNameException;
import kinugasa.resource.Nameable;
import kinugasa.resource.Storage;

/**
 * "ړi"܂"蕨"NX́A}bv`bvɑ΂ړ̉ۂ𔻒肵܂.
 * <br>
 * ړíuړ\ȃ`bvv܂B<br>
 * }bvŃLN^ړ悤ƂƁAɏ}bv`bv̎ ƁÄ݂ړiiVehicleStorage.currentVehicleǰs܂B<br>
 * <br>
 * ړíÄړî̈ړx܂B<br>
 * }bṽXN[x́Au}bv̂̈ړx~ړïړxvgp܂B
 * <br>
 *
 * @version 1.0.0 - 2013/04/28_21:43:17<br>
 * @author Dra0211<br>
 */
public class Vehicle implements Nameable, Serializable, Comparable<Vehicle> {

	private static final long serialVersionUID = -5624691892456676247L;
	/**
	 * ړïӓIȖOł.
	 */
	private String name;
	/**
	 * ̈ړi}bvXN[鑬xł. ړx́u}bv̂̈ړx~ړïړxvgp܂B
	 */
	private float speed;
	/**
	 * ̈ړiړł鑮ł.
	 */
	private Storage<ChipAttribute> attributeStorage;

	/**
	 * Vړi쐬܂. 쐬ꂽړíAIVehicleStorageɒǉ܂B<br>
	 *
	 * @param name ړïӓIȖOw肵܂B<br>
	 * @param speed ړïړxw肵܂B1.0fw肷ƁA }bvɐݒ肳ꂽړxňړ܂B<br>
	 * @param attributeSet ̈ړiړł`bv𑗐M܂B<br>
	 * @throws DuplicateNameException ̈ړi̖OłɎgpĂƂ ܂B<br>
	 */
	public Vehicle(String name, float speed, ChipAttribute... attributeSet)
			throws DuplicateNameException {
		this(name, speed, Arrays.asList(attributeSet));
	}

	/**
	 * Vړi쐬܂. 쐬ꂽړíAIVehicleStorageɒǉ܂B<br>
	 *
	 * @param name ړïӓIȖOw肵܂B<br>
	 * @param speed ړïړxw肵܂B1.0fw肷ƁA }bvɐݒ肳ꂽړxňړ܂B<br>
	 * @param attributeSet ̈ړiړł`bv𑗐M܂B<br>
	 * @throws DuplicateNameException ̈ړi̖OłɎgpĂƂ ܂B<br>
	 */
	public Vehicle(String name, float speed, Collection<ChipAttribute> attributeSet)
			throws DuplicateNameException {
		if (VehicleStorage.getInstance().contains(name)) {
			throw new DuplicateNameException("duplicate name : " + name);
		}
		this.name = name;
		this.speed = speed;
		this.attributeStorage = new Storage<ChipAttribute>();
		this.attributeStorage.addAll(attributeSet);
		addThis();
	}

	/**
	 * thisCX^XVehicleStorageɒǉ܂.
	 */
	private void addThis() {
		VehicleStorage.getInstance().add(this);
	}

	@Override
	public String getName() {
		return name;
	}

	/**
	 * ړïړx擾܂.
	 *
	 * @return ړxԂ܂B<br>
	 */
	public float getSpeed() {
		return speed;
	}

	/**
	 * ړïړxݒ肵܂.
	 *
	 * @param speed ړxw肵܂B<Br>
	 */
	public void setSpeed(float speed) {
		this.speed = speed;
	}

	/**
	 * ̈ړiړ\ȑi[ꂽXg[W擾܂.
	 *
	 * @return ړ\ȑi[ꂽXg[WԂ܂B "VOID"͒ǉĂ܂B<br>
	 */
	public Storage<ChipAttribute> getAttributeStorage() {
		return attributeStorage;
	}

	/**
	 * ̈ړiw肳ꂽ`bvɈړ\ł邩܂. ̎菇Ō܂B<br>
	 * <ol>
	 * <li>CLOSEVOIĎ</li>
	 * <br>
	 * Mꂽ`bvA"VOID"̏ꍇAKtrueԂ܂B<br>
	 * ܂AMꂽ`bvA"CLOSE"̏ꍇAKfalseԂ܂B<br>
	 * <br>
	 * <li>ړ۔</li>
	 * <br>
	 * ̈ړiړ\ȑۊǂꂽXg[W MꂽƓOCX^X݂ꍇAtrueԂ܂B<ber>
	 * <br>
	 * </ol>
	 *
	 * @param attribute LN^ɏ`bv̑𑗐M܂B<br>
	 * @return ̈ړiattributeɈړłꍇtrueAړłȂꍇfalseԂ܂B<br>
	 */
	public boolean stepOn(ChipAttribute attribute) {
		if (ChipAttributeStorage.getInstance().get("CLOSE").equals(attribute)) {
			return false;
		}
		if (ChipAttributeStorage.getInstance().get("VOID").equals(attribute)) {
			return true;
		}
		return this.attributeStorage.contains(attribute);
	}

	//ׂďƂtrueԂ
	public boolean stepOn(List<ChipAttribute> attr) {
		for (int i = 0, size = attr.size(); i < size; i++) {
			if (!stepOn(attr.get(i))) {
				return false;
			}
		}
		return true;
	}

	@Override
	public String toString() {
		return "Vehicle{" + "name=" + name + ", speed=" + speed + ", attributeStorage=" + attributeStorage + '}';
	}

	@Override
	public int hashCode() {
		int hash = 3;
		hash = 41 * hash + (this.name != null ? this.name.hashCode() : 0);
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final Vehicle other = (Vehicle) obj;
		if ((this.name == null) ? (other.name != null) : !this.name.equals(other.name)) {
			return false;
		}
		return true;
	}

	@Override
	public int compareTo(Vehicle o) {
		return this.name.compareTo(o.getName());
	}
}
