/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.util;

import java.io.Serializable;

public final class Random
implements Serializable {
    private static final long serialVersionUID = 4919268115768305696L;
    private static long seed;
    private static java.util.Random random;

    private Random() {
    }

    public static long initSeed() {
        return Random.initSeed(System.nanoTime());
    }

    public static long initSeed(long seed) {
        Random.seed = seed;
        random = new java.util.Random(Random.seed);
        return seed;
    }

    public static long getSeed() {
        if (random == null) {
            Random.initSeed();
        }
        return seed;
    }

    public static float randomFloat() {
        if (random == null) {
            Random.initSeed();
        }
        return random.nextFloat();
    }

    public static float randomFloat(float maxValue) {
        if (random == null) {
            Random.initSeed();
        }
        return Random.randomFloat() * maxValue;
    }

    public static int randomInt() {
        if (random == null) {
            Random.initSeed();
        }
        return random.nextInt();
    }

    public static int randomAbsInt(int maxValue) {
        if (random == null) {
            Random.initSeed();
        }
        return random.nextInt(maxValue < 0 ? 0 : maxValue);
    }

    public static int randomAbsInt() {
        return Math.abs(Random.randomInt());
    }

    public static boolean randomBool() {
        if (random == null) {
            Random.initSeed();
        }
        return random.nextBoolean();
    }

    public static boolean percent(float p) {
        if (p <= 0.0f) {
            return false;
        }
        if (p >= 1.0f) {
            return true;
        }
        return Random.randomFloat() < p;
    }

    public static int dice(int num, int sided) {
        return Random.randomAbsInt(sided * num - num + 1) + num;
    }

    public static int d3(int num) {
        return Random.dice(num, 3);
    }

    public static int d4(int num) {
        return Random.dice(num, 4);
    }

    public static int d6(int num) {
        return Random.dice(num, 6);
    }

    public static int d8(int num) {
        return Random.dice(num, 8);
    }

    public static int d10(int num) {
        return Random.dice(num, 10);
    }

    public static int d12(int num) {
        return Random.dice(num, 12);
    }

    public static int d20(int num) {
        return Random.dice(num, 20);
    }

    public static int d24(int num) {
        return Random.dice(num, 24);
    }

    public static int d30(int num) {
        return Random.dice(num, 30);
    }

    public static int d50(int num) {
        return Random.dice(num, 50);
    }

    public static int d100(int num) {
        return Random.dice(num, 100);
    }
}

