/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.util;

public final class MathUtil {
    private static final float[] sinTable = new float[720];
    private static final float[] cosTable = new float[720];

    private MathUtil() {
    }

    public static void init() {
        int i;
        System.out.println("kinugasa.util.MathUtil.methodName()");
        for (i = 0; i < sinTable.length; ++i) {
            MathUtil.sinTable[i] = (float)Math.sin(Math.toRadians((float)i / 2.0f));
        }
        for (i = 0; i < cosTable.length; ++i) {
            MathUtil.cosTable[i] = (float)Math.cos(Math.toRadians((float)i / 2.0f));
        }
    }

    public static float[] createSinWaveArray(float fq, float mag, float max) {
        float[] reAry = new float[(int)(max / fq)];
        for (int i = 0; i < reAry.length; ++i) {
            reAry[i] = (float)Math.sin(Math.toRadians((float)i * fq)) * mag;
        }
        return reAry;
    }

    public static float[] createSinWaveArray(float fq, float mag, float max, boolean reverse) {
        float[] reAry = new float[(int)(max / fq)];
        for (int i = 0; i < reAry.length; ++i) {
            reAry[i] = (float)Math.sin(Math.toRadians((float)i * fq)) * mag;
            if (!reverse) continue;
            reAry[i] = -reAry[i];
        }
        return reAry;
    }

    public static float sin(float angle) {
        int index = (int)(angle + angle);
        if (index < sinTable.length && index >= 0) {
            return sinTable[index];
        }
        return MathUtil.sin(angle < 0.0f ? angle + 360.0f : angle - 360.0f);
    }

    public static float cos(float angle) {
        int index = (int)(angle + angle);
        if (index < cosTable.length && index >= 0) {
            return cosTable[index];
        }
        return MathUtil.cos(angle < 0.0f ? angle + 360.0f : angle - 360.0f);
    }
}

