/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource.text;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kinugasa.game.GameLog;
import kinugasa.resource.Input;
import kinugasa.resource.InputStatus;
import kinugasa.resource.Output;
import kinugasa.resource.OutputResult;
import kinugasa.resource.text.FileFormatException;
import kinugasa.resource.text.FileIOException;
import kinugasa.resource.text.FileNotFoundException;

public class IniFile
implements Input<IniFile>,
Output {
    private final File file;
    private final Map<String, Value> map;
    private InputStatus status = InputStatus.NOT_LOADED;

    public IniFile(String fileName) {
        this(new File(fileName));
    }

    public IniFile(File file) {
        this.file = file;
        this.map = new HashMap<String, Value>();
    }

    @Override
    public IniFile load() throws FileNotFoundException, FileFormatException {
        this.addAll(this.file);
        return this;
    }

    private IniFile addAll(File file) {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(file);
        }
        try {
            for (String line : Files.readAllLines(file.toPath())) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("[")) {
                    if (line.endsWith("]")) continue;
                    throw new FileFormatException(file, line);
                }
                if (!line.contains("=")) {
                    throw new FileFormatException(file, line);
                }
                String[] val = line.split("=");
                this.map.put(val[0], new Value(val[1]));
            }
        }
        catch (IOException ex) {
            throw new FileIOException(ex);
        }
        this.status = InputStatus.LOADED;
        GameLog.printInfoIfUsing(file.getPath());
        this.map.entrySet().forEach(e -> GameLog.printInfoIfUsing((String)e.getKey() + "=" + e.getValue()));
        return this;
    }

    @Override
    public void dispose() {
        this.map.clear();
        this.status = InputStatus.NOT_LOADED;
    }

    @Override
    public InputStatus getStatus() {
        return this.status;
    }

    @Override
    public OutputResult save() throws FileIOException {
        return this.saveTo(this.file);
    }

    @Override
    public OutputResult saveTo(File f) throws FileIOException {
        try {
            ArrayList list = new ArrayList();
            this.map.entrySet().forEach(e -> list.add((String)e.getKey() + e.getValue()));
            Files.write(f.toPath(), list, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            throw new FileIOException(ex);
        }
        return OutputResult.OK;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Value getValue(String key) {
        return this.map.get(key);
    }

    public Optional<Value> get(String key) {
        return Optional.of(this.getValue(key));
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public void put(String key, Value v) {
        this.map.put(key, v);
    }

    public IniFile addAll(String filePath) {
        return this.addAll(new File(filePath));
    }

    public static final class Value {
        private final String value;

        public Value(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public int asInt() throws NumberFormatException {
            return Integer.parseInt(this.value);
        }

        public long asLong() throws NumberFormatException {
            return Long.parseLong(this.value);
        }

        public float asFloat() throws NumberFormatException {
            return Float.parseFloat(this.value);
        }

        public List<String> asCsv() {
            if (this.value.contains(",")) {
                return Arrays.asList(this.value.split(","));
            }
            return List.of();
        }

        public Value asCsvOf(int i) {
            return new Value(this.asCsv().get(i));
        }

        public boolean isTrue() {
            return "true".equals(this.value.toLowerCase());
        }

        public boolean is(String val) {
            return val.equals(this.value);
        }

        public boolean is(int val) {
            return this.asInt() == val;
        }

        public boolean is(long val) {
            return this.asLong() == val;
        }

        public boolean is(float val) {
            return this.asFloat() == val;
        }

        public String toString() {
            return this.value;
        }
    }
}

