/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kinugasa.resource.ContentsIO;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.FileNotFoundException;
import kinugasa.resource.Nameable;

public abstract class SaveData
implements Nameable,
Serializable {
    private static final long serialVersionUID = 5051478173983169607L;
    private String name;
    private long createTime;
    private Date date;

    public SaveData() {
        this("");
    }

    public SaveData(String name) {
        this.name = name;
        this.createTime = System.currentTimeMillis();
        this.date = new Date();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final Date getDate() {
        return this.date;
    }

    public final void setDate(Date date) {
        this.date = date;
    }

    public final long getCreateTime() {
        return this.createTime;
    }

    public final void save(File file) throws FileNotFoundException, ContentsIOException {
        ContentsIO.save(this, file);
    }

    public static SaveData load(File file) throws FileNotFoundException, ContentsIOException {
        return ContentsIO.load(SaveData.class, file);
    }

    public static List<SaveData> loadAll(File dir) throws FileNotFoundException, ContentsIOException, IllegalArgumentException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir is not directory");
        }
        File[] files = dir.listFiles();
        ArrayList<SaveData> result = new ArrayList<SaveData>(files.length);
        for (File file : files) {
            if (file.isDirectory()) {
                result.addAll(SaveData.loadAll(file));
                continue;
            }
            try {
                result.add(ContentsIO.load(SaveData.class, file));
            }
            catch (FileNotFoundException ex) {
            }
            catch (ContentsIOException ex) {
                // empty catch block
            }
        }
        return result;
    }

    public String toString() {
        return "SaveData{name=" + this.name + ", createTime=" + this.createTime + ", date=" + this.date + "}";
    }
}

