/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.resource;

import java.util.Collection;
import java.util.function.Consumer;
import kinugasa.resource.DuplicateNameException;
import kinugasa.resource.Input;
import kinugasa.resource.InputStatus;
import kinugasa.resource.NameNotFoundException;
import kinugasa.resource.Nameable;
import kinugasa.resource.Storage;
import kinugasa.util.ArrayUtil;

public abstract class DynamicStorage<T extends Nameable & Input>
extends Storage<T>
implements Input {
    public DynamicStorage(int initialSize) {
        super(initialSize);
    }

    public DynamicStorage() {
    }

    public DynamicStorage<T> load() {
        for (Nameable obj : this) {
            ((Input)((Object)obj)).load();
        }
        return this;
    }

    public T load(String name) throws NameNotFoundException {
        Object obj = this.get(name);
        ((Input)obj).load();
        return obj;
    }

    @Override
    public void dispose() {
        for (Nameable obj : this) {
            ((Input)((Object)obj)).dispose();
        }
    }

    public T dispose(String name) throws NameNotFoundException {
        Object obj = this.get(name);
        ((Input)obj).dispose();
        return obj;
    }

    public void loadAll(String ... names) {
        for (Nameable obj : this) {
            if (!ArrayUtil.contains(names, obj.getName())) continue;
            ((Input)((Object)obj)).load();
        }
    }

    public void freeAll(String ... names) {
        for (Nameable obj : this) {
            if (!ArrayUtil.contains(names, obj.getName())) continue;
            ((Input)((Object)obj)).dispose();
        }
    }

    public void exFree(String ... names) {
        for (Nameable obj : this) {
            if (ArrayUtil.contains(names, obj.getName())) continue;
            ((Input)((Object)obj)).dispose();
        }
    }

    @Override
    public InputStatus getStatus() {
        return this.isEmpty() ? InputStatus.NOT_LOADED : InputStatus.LOADED;
    }

    public boolean isLoadedAll() {
        for (Nameable obj : this) {
            if (((Input)((Object)obj)).getStatus() == InputStatus.LOADED) continue;
            return false;
        }
        return true;
    }

    public boolean isLoaded(String name) throws NameNotFoundException {
        return this.contains(name) ? ((Input)this.get(name)).getStatus() == InputStatus.LOADED : false;
    }

    @Override
    public void forEach(Consumer<? super T> c) {
        super.forEach(c);
    }

    @Override
    public void addAll(Collection<? extends T> values) throws DuplicateNameException {
        super.addAll(values);
    }
}

