/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.geom.Point2D;
import kinugasa.util.MathUtil;

public class TVector
implements Cloneable {
    public static final float EAST = 90.0f;
    public static final float SOUTH_EAST = 135.0f;
    public static final float SOUTH = 180.0f;
    public static final float SOUTH_WEST = 225.0f;
    public static final float WEST = 270.0f;
    public static final float NORTH_WEST = 315.0f;
    public static final float NORTH = 0.0f;
    public static final float NORTH_EAST = 45.0f;
    public float angle;
    public float speed;

    public TVector() {
        this(0.0f, 0.0f);
    }

    public TVector(float angle, float speed) {
        this.angle = angle;
        this.speed = speed;
    }

    public TVector(float speed) {
        this.angle = 0.0f;
        this.speed = speed;
    }

    public TVector(Point2D.Float location) {
        this((float)Math.toDegrees(Math.atan2(location.y, location.x)) + 90.0f, (float)Point2D.distance(0.0, 0.0, location.x, location.y));
    }

    public void clamp() {
        while (this.angle >= 360.0f) {
            this.angle -= 360.0f;
        }
        while (this.angle < 0.0f) {
            this.angle += 360.0f;
        }
    }

    public void add(TVector v) {
        this.setLocation(this.getX() + v.getX(), this.getY() + v.getY());
    }

    public static TVector add(TVector v1, TVector v2) {
        TVector result = new TVector();
        result.setLocation(v1.getX() + v2.getX(), v1.getY() + v2.getY());
        return result;
    }

    public void sub(TVector v) {
        this.setLocation(this.getX() - v.getX(), this.getY() - v.getY());
    }

    public static TVector sub(TVector v1, TVector v2) {
        TVector result = new TVector();
        result.setLocation(v1.getX() - v2.getX(), v1.getY() - v2.getY());
        return result;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getAngleAsRad() {
        return (float)Math.toRadians(this.angle);
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setX(float x) {
        this.setLocation(x, this.getY());
    }

    public void setY(float y) {
        this.setLocation(this.getX(), y);
    }

    public float getX() {
        return this.speed * MathUtil.sin(this.angle);
    }

    public float getY() {
        return -this.speed * MathUtil.cos(this.angle);
    }

    public Point2D.Float getLocation() {
        return new Point2D.Float(this.getX(), this.getY());
    }

    public Point2D.Float getLocationOnScreen() {
        Point2D.Float result = this.getLocation();
        result.y = -result.y;
        return result;
    }

    public void setLocation(float x, float y) {
        this.angle = (float)Math.toDegrees(Math.atan2(y, x)) + 90.0f;
        this.speed = (float)Point2D.distance(0.0, 0.0, x, y);
    }

    public TVector clone() {
        try {
            return (TVector)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("clone failed");
        }
    }

    public boolean equalsInt(TVector obj) {
        return (int)obj.getAngle() == (int)this.getAngle() && (int)obj.getSpeed() == (int)this.getSpeed();
    }

    public boolean equalsValue(TVector obj) {
        return obj.getSpeed() == this.getSpeed() && obj.getAngle() == this.getAngle();
    }

    public boolean checkRange(float centerDeg, float openDeg) {
        float ang = TVector.clamp(this.angle);
        float min = centerDeg - openDeg / 2.0f;
        float max = centerDeg + openDeg / 2.0f;
        return ang <= max && ang >= min;
    }

    public boolean checkRange(TVector centerDeg, float openDeg) {
        return this.checkRange(centerDeg.getAngle(), openDeg);
    }

    public String toString() {
        return "VectorF{angle=" + this.angle + ", speed=" + this.speed + "}";
    }

    public float sin() {
        return MathUtil.sin(TVector.clamp(this.angle));
    }

    public float cos() {
        return MathUtil.cos(TVector.clamp(this.angle));
    }

    public void addAngle(float a) {
        this.angle += a;
    }

    public void addAngle(TVector v) {
        this.addAngle(v.angle);
    }

    public void spreadAngle(float width) {
        this.angle -= width / 2.0f;
        this.angle += (float)Math.random() * width;
    }

    public void setAngle(Point2D.Float p1, Point2D.Float p2) {
        this.angle = (float)Math.toDegrees(Math.atan2(p2.y - p1.y, p2.x - p1.x) + Math.toRadians(90.0));
    }

    public static float clamp(float deg) {
        while (deg >= 360.0f) {
            deg -= 360.0f;
        }
        while (deg < 0.0f) {
            deg += 360.0f;
        }
        return deg;
    }
}

