/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import kinugasa.resource.Nameable;

public class Parameter
implements Nameable,
Cloneable {
    private String name;
    private String description;
    private float value;
    private float maxValue;
    private float minValue = 0.0f;

    public Parameter(String name, float value) {
        this(name, value, Float.POSITIVE_INFINITY);
    }

    public Parameter(String name, float value, float maxValue) {
        this(name, value, 0.0f, maxValue);
    }

    public Parameter(String name, float value, float minValue, float maxValue) {
        this.name = name;
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public Parameter(String name, String discription, float value) {
        this(name, discription, value, Float.POSITIVE_INFINITY);
    }

    public Parameter(String name, String discription, float value, float maxValue) {
        this(name, discription, value, 0.0f, maxValue);
    }

    public Parameter(String name, String discription, float value, float minValue, float maxValue) {
        this.name = name;
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.description = discription;
    }

    public void toMax() {
        this.value = this.maxValue;
    }

    public void toMin() {
        this.value = this.minValue;
    }

    public boolean isZero() {
        return this.value == 0.0f;
    }

    public boolean ltMin() {
        return this.value < this.minValue;
    }

    public boolean leMin() {
        return this.value <= this.minValue;
    }

    public boolean gtMax() {
        return this.value > this.maxValue;
    }

    public boolean geMax() {
        return this.value >= this.maxValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float get() {
        return this.value;
    }

    public void set(float value) {
        this.value = value;
    }

    public int getInt() {
        return (int)this.value;
    }

    public void add(float value) {
        this.value += value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 53 * hash + Float.floatToIntBits(this.value);
        hash = 53 * hash + Float.floatToIntBits(this.maxValue);
        hash = 53 * hash + Float.floatToIntBits(this.minValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (Float.floatToIntBits(this.value) != Float.floatToIntBits(other.value)) {
            return false;
        }
        if (Float.floatToIntBits(this.maxValue) != Float.floatToIntBits(other.maxValue)) {
            return false;
        }
        return Float.floatToIntBits(this.minValue) == Float.floatToIntBits(other.minValue);
    }

    public String toString() {
        return "Parameter{name=" + this.name + ", value=" + this.value + ", maxValue=" + this.maxValue + ", minValue=" + this.minValue + "}";
    }

    public Parameter clone() {
        try {
            return (Parameter)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("clone failed");
        }
    }
}

