/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import kinugasa.game.GraphicsContext;
import kinugasa.object.ImagePainter;
import kinugasa.object.ImageSprite;
import kinugasa.resource.Storage;
import kinugasa.resource.TImage;

public final class ImagePainterStorage
extends Storage<ImagePainter> {
    public static final ImagePainter NOT_DRAW = new ImagePainter("NOT_DRAW"){

        @Override
        public void draw(GraphicsContext g, ImageSprite spr) {
        }
    };
    public static final ImagePainter IMAGE_BOUNDS_XY = new ImagePainter("IMAGE_BOUNDS_XY"){

        @Override
        public void draw(GraphicsContext g, ImageSprite spr) {
            g.drawImage(spr.getImage(), (int)spr.getX(), (int)spr.getY());
        }
    };
    public static final ImagePainter IMAGE_BOUNDS_CENTER = new ImagePainter("IMAGE_BOUNDS_CENTER"){

        @Override
        public void draw(GraphicsContext g, ImageSprite spr) {
            g.drawImage(spr.getImage(), (int)(spr.getCenterX() - (float)(spr.getImageWidth() / 2)), (int)(spr.getCenterY() - (float)(spr.getImageHeight() / 2)));
        }
    };
    public static final ImagePainter SPRITE_BOUNDS = new ImagePainter("SPRITE_BOUNDS"){

        @Override
        public void draw(GraphicsContext g, ImageSprite spr) {
            g.drawImage(spr.getImage(), (int)spr.getX(), (int)spr.getY(), (int)spr.getWidth(), (int)spr.getHeight());
        }
    };
    public static final ImagePainter IMAGE_BOUNDS_XY_ROTATE = new ImagePainter("IMAGE_BOUNDS_XY_ROTATE"){

        @Override
        public void draw(GraphicsContext g, ImageSprite spr) {
            Graphics2D g2 = g.create();
            g2.setClip(spr.getBounds());
            g2.rotate(spr.getVector().getAngleAsRad(), spr.getCenterX(), spr.getCenterY());
            g2.drawImage(spr.getImage().asImage(), (int)spr.getX(), (int)spr.getY(), null);
            g2.dispose();
        }
    };
    public static final ImagePainter IMAGE_BOUNDS_CENTER_ROTATE = new ImagePainter("IMAGE_BOUNDS_CENTER_ROTATE"){

        @Override
        public void draw(GraphicsContext g, ImageSprite spr) {
            Graphics2D g2 = g.create();
            g2.setClip(spr.getBounds());
            g2.rotate(spr.getVector().getAngleAsRad(), spr.getCenterX(), spr.getCenterY());
            g2.drawImage(spr.getImage().asImage(), (int)(spr.getCenterX() - (float)(spr.getImageWidth() / 2)), (int)(spr.getCenterY() - (float)(spr.getImageHeight() / 2)), null);
            g2.dispose();
        }
    };
    public static final ImagePainter SPRITE_BOUNDS_ROTATE = new ImagePainter("SPRITE_BOUNDS_ROTATE"){

        @Override
        public void draw(GraphicsContext g, ImageSprite spr) {
            Graphics2D g2 = g.create();
            g2.setClip(spr.getBounds());
            g2.rotate(spr.getVector().getAngleAsRad(), spr.getCenterX(), spr.getCenterY());
            g2.drawImage(spr.getImage().asImage(), (int)spr.getX(), (int)spr.getY(), (int)spr.getWidth(), (int)spr.getHeight(), null);
            g2.dispose();
        }
    };
    public static final ImagePainter DEBUG_SPRITE_BOUNDS = new ImagePainter("DEBUG_SPRITE_BOUNDS"){

        @Override
        public void draw(GraphicsContext g, ImageSprite spr) {
            g.setColor(Color.GREEN);
            g.draw((List)((Object)spr.getBounds()));
            g.setColor(Color.RED);
            g.draw(spr.getHitBounds());
        }
    };
    public static final ImagePainter TITLING_CPLI_AREA = new ImagePainter("TILING_IMAGE_SIZE"){

        @Override
        public void draw(GraphicsContext g, ImageSprite sprite) {
            float minX;
            float minY = sprite.getY();
            for (minX = sprite.getX(); minX >= 0.0f; minX -= (float)sprite.getImageWidth()) {
            }
            while (minY >= 0.0f) {
                minY -= (float)sprite.getImageHeight();
            }
            TImage image = sprite.getImage();
            float totalHeight = -minY + (float)g.getClipBounds().height;
            float totalWidth = -minX + (float)g.getClipBounds().width;
            for (float y = minY; y < totalHeight; y += (float)image.getHeight()) {
                for (float x = minX; x < totalWidth; x += (float)image.getWidth()) {
                    g.drawImage(image.get(), (int)x, (int)y);
                }
            }
        }
    };
    public static final ImagePainter TILING_SPRITE_SIZE = new ImagePainter("TILING_SPRITE_SIZE"){

        @Override
        public void draw(GraphicsContext g, ImageSprite sprite) {
            float minX;
            float minY = sprite.getY();
            for (minX = sprite.getX(); minX >= 0.0f; minX -= (float)sprite.getImageWidth()) {
            }
            while (minY >= 0.0f) {
                minY -= (float)sprite.getImageHeight();
            }
            TImage image = sprite.getImage();
            float totalHeight = -minY + sprite.getHeight();
            float totalWidth = -minX + sprite.getWidth();
            for (float y = minY; y < totalHeight; y += (float)image.getHeight()) {
                for (float x = minX; x < totalWidth; x += (float)image.getWidth()) {
                    g.drawImage(image.get(), (int)x, (int)y);
                }
            }
        }
    };
    private static final long serialVersionUID = 2147787454213377482L;
    private static final ImagePainterStorage INSTANCE = new ImagePainterStorage();

    public static ImagePainterStorage getInstance() {
        return INSTANCE;
    }

    private ImagePainterStorage() {
        this.add(NOT_DRAW);
        this.add(IMAGE_BOUNDS_XY);
        this.add(IMAGE_BOUNDS_XY_ROTATE);
        this.add(IMAGE_BOUNDS_CENTER);
        this.add(IMAGE_BOUNDS_CENTER_ROTATE);
        this.add(SPRITE_BOUNDS);
        this.add(SPRITE_BOUNDS_ROTATE);
        this.add(DEBUG_SPRITE_BOUNDS);
        this.add(TILING_SPRITE_SIZE);
        this.add(TITLING_CPLI_AREA);
    }
}

