/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.object;

import kinugasa.game.GraphicsContext;
import kinugasa.graphics.ColorChanger;
import kinugasa.graphics.GraphicsUtil;
import kinugasa.object.ScreenEffect;

public class FadeEffect
extends ScreenEffect {
    private ColorChanger color;
    private ColorChanger initialColor;
    private boolean running = false;
    private boolean ended = false;

    public FadeEffect(float width, float height, ColorChanger color) {
        super(width, height);
        this.color = color;
        this.initialColor = color.clone();
    }

    @Override
    public void draw(GraphicsContext g) {
        if (!this.isVisible() || !this.isExist()) {
            return;
        }
        if (this.ended) {
            return;
        }
        this.running = true;
        g.setColor(this.color.createColor());
        GraphicsUtil.fillRect(g, this.getBounds());
        this.color.update();
        this.ended = this.color.isEnded();
    }

    @Override
    public boolean isEnded() {
        return this.ended;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void reset() {
        this.color = this.initialColor.clone();
        this.ended = false;
    }
}

