/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.graphics;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Iterator;
import kinugasa.resource.TImage;
import kinugasa.util.ArrayIndexModel;
import kinugasa.util.SimpleIndex;
import kinugasa.util.TimeCounter;

public class Animation
implements Iterable<TImage>,
Cloneable {
    private TimeCounter visibleTime;
    private ArrayIndexModel index;
    private TImage[] images;

    public Animation(TimeCounter visibleTime, BufferedImage ... images) {
        this(visibleTime, (ArrayIndexModel)new SimpleIndex(), images);
    }

    public Animation(TimeCounter visibleTime, TImage ... images) {
        this(visibleTime, (ArrayIndexModel)new SimpleIndex(), images);
    }

    public Animation(TimeCounter visibleTime, ArrayIndexModel index, BufferedImage ... images) {
        this.visibleTime = visibleTime;
        this.index = index;
        this.images = new TImage[images.length];
        for (int i = 0; i < images.length; ++i) {
            this.images[i] = new TImage(images[i]);
        }
    }

    public Animation(TimeCounter visibleTime, ArrayIndexModel index, TImage ... images) {
        this.visibleTime = visibleTime;
        this.index = index;
        this.images = images;
    }

    public TImage[] getImages() {
        return this.images;
    }

    public TImage getImage(int index) throws ArrayIndexOutOfBoundsException {
        if (this.images == null) {
            return null;
        }
        return this.images[index];
    }

    public void setImages(TImage ... images) {
        this.images = images;
    }

    public void setImages(BufferedImage ... images) {
        this.images = new TImage[images.length];
        for (int i = 0; i < images.length; ++i) {
            this.images[i] = new TImage(images[i]);
        }
    }

    public void setImage(int index, BufferedImage image) throws ArrayIndexOutOfBoundsException {
        this.setImage(index, new TImage(image));
    }

    public void setImage(int index, TImage image) {
        this.images[index] = image;
    }

    public void setIndex(ArrayIndexModel index) {
        this.index = index;
    }

    public ArrayIndexModel getIndex() {
        return this.index;
    }

    public void setVisibleTime(TimeCounter visibleTime) {
        this.visibleTime = visibleTime;
    }

    public TimeCounter getVisibleTime() {
        return this.visibleTime;
    }

    public void update() {
        if (this.visibleTime.isReaching()) {
            this.index.index(this.images == null ? 0 : this.images.length);
        }
    }

    public TImage getCurrentImage() {
        return this.images == null ? null : this.images[this.index.getIndex()];
    }

    public BufferedImage getCurrentBImage() {
        return this.images == null ? null : this.images[this.index.getIndex()].get();
    }

    public int length() {
        return this.images == null ? 0 : this.images.length;
    }

    @Override
    public Iterator<TImage> iterator() {
        return Arrays.asList(this.images).iterator();
    }

    public Animation clone() {
        try {
            Animation result = (Animation)super.clone();
            if (this.images != null) {
                result.images = (TImage[])this.images.clone();
            }
            result.index = this.index.clone();
            result.visibleTime = this.visibleTime.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("clone failed");
        }
    }

    public String toString() {
        return "Animation{visibleTime=" + this.visibleTime + ", index=" + this.index + ", images=" + this.images + "}";
    }
}

