/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.ui;

import java.awt.Graphics2D;
import kinugasa.game.GraphicsContext;
import kinugasa.game.ui.FontModel;
import kinugasa.game.ui.TextLabelModelStorage;
import kinugasa.game.ui.TextLabelSprite;
import kinugasa.object.Model;
import kinugasa.resource.Nameable;

public abstract class TextLabelModel
extends Model
implements Nameable {
    private final String name;
    private FontModel font;

    public TextLabelModel(String name, FontModel font) {
        this.name = name;
        this.font = font;
        this.addThis();
    }

    private void addThis() {
        if (!TextLabelModelStorage.getInstance().contains(this.name)) {
            TextLabelModelStorage.getInstance().add(this);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final void setProperty(Graphics2D g) {
        g.setFont(this.font.getFont());
        g.setColor(this.font.getColor());
    }

    public abstract void draw(GraphicsContext var1, TextLabelSprite var2);

    public int getFontSize() {
        return this.font.getFont().getSize();
    }

    public FontModel getFontConfig() {
        return this.font;
    }

    @Override
    public TextLabelModel clone() {
        return (TextLabelModel)super.clone();
    }
}

