/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.awt.geom.Point2D;
import kinugasa.game.GraphicsContext;
import kinugasa.game.rpgui.MessageWindowModel;
import kinugasa.game.rpgui.Text;
import kinugasa.game.rpgui.TextStorage;
import kinugasa.object.AnimationSprite;
import kinugasa.object.BasicSprite;
import kinugasa.util.TimeCounter;

public class MessageWindowSprite
extends BasicSprite {
    private MessageWindowModel windowModel;
    private Text currentText;
    private TextStorage textStorage;
    private int lineLength = 32;
    private AnimationSprite continueIcon = null;
    private AnimationSprite selectIcon = null;

    private void resetContinueIconLocation(Point2D.Float windowOldLocation, Point2D.Float windowNewLocation) {
        System.out.println("old:" + windowOldLocation);
        System.out.println("new:" + windowNewLocation);
        float cIconXGap = this.continueIcon.getX() - windowOldLocation.x;
        float cIconYGap = this.continueIcon.getY() - windowOldLocation.y;
        System.out.println("X:" + cIconXGap);
        System.out.println("Y:" + cIconYGap);
        this.continueIcon.setX(windowNewLocation.x + cIconXGap);
        this.continueIcon.setY(windowNewLocation.y + cIconYGap);
    }

    public MessageWindowSprite(MessageWindowModel model, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.currentText = new Text();
        this.windowModel = model;
        this.textStorage = null;
    }

    public MessageWindowSprite(String text, MessageWindowModel model, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.currentText = new Text(text, TimeCounter.TRUE);
        this.windowModel = model;
        this.textStorage = null;
    }

    public MessageWindowSprite(String text, TimeCounter tc, MessageWindowModel model, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.currentText = new Text(text, tc);
        this.windowModel = model;
        this.textStorage = null;
    }

    public MessageWindowSprite(String[] text, TimeCounter tc, MessageWindowModel model, float x, float y, float width, float height) {
        super(x, y, width, height);
        StringBuilder b = new StringBuilder();
        for (String line : text) {
            b.append(line);
        }
        this.currentText = new Text(b.toString(), tc);
        this.windowModel = model;
        this.textStorage = null;
    }

    public MessageWindowSprite(Text text, TimeCounter tc, MessageWindowModel model, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.currentText = text;
        this.windowModel = model;
        this.textStorage = null;
    }

    @Override
    public void draw(GraphicsContext g) {
        if (this.isVisible() & this.isExist()) {
            this.windowModel.draw(g, this);
        }
    }

    public MessageWindowSprite setLineLength(int lineLength) {
        this.lineLength = lineLength;
        return this;
    }

    public MessageWindowSprite setContinueIcon(AnimationSprite continueIcon) {
        this.continueIcon = continueIcon;
        return this;
    }

    public MessageWindowSprite setSelectIcon(AnimationSprite selectIcon) {
        this.selectIcon = selectIcon;
        return this;
    }

    public MessageWindowSprite setTextStorage(TextStorage textStorage) {
        this.textStorage = textStorage;
        return this;
    }

    public void setText(String text) {
        this.setText(new Text(text, TimeCounter.TRUE));
    }

    public void setText(Text text) {
        this.currentText = text;
    }

    public MessageWindowModel getWindowModel() {
        return this.windowModel;
    }

    public Text getCurrentText() {
        return this.currentText;
    }

    public TextStorage getTextStorage() {
        return this.textStorage;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public AnimationSprite getContinueIcon() {
        return this.continueIcon;
    }

    public AnimationSprite getSelectIcon() {
        return this.selectIcon;
    }

    public String[] split() {
        return this.currentText.split(this.lineLength);
    }

    @Override
    public MessageWindowSprite clone() {
        MessageWindowSprite result = (MessageWindowSprite)super.clone();
        result.windowModel = this.windowModel.clone();
        result.selectIcon = this.selectIcon.clone();
        result.continueIcon = this.continueIcon.clone();
        return result;
    }

    @Override
    public void setX(float x) {
        Point2D.Float oldLocation = (Point2D.Float)this.getLocation().clone();
        super.setX(x);
        this.resetContinueIconLocation(oldLocation, this.getLocation());
    }

    @Override
    public void setY(float y) {
        Point2D.Float oldLocation = (Point2D.Float)this.getLocation().clone();
        super.setY(y);
        this.resetContinueIconLocation(oldLocation, this.getLocation());
    }

    @Override
    public void setLocation(Point2D.Float location) {
        Point2D.Float oldLocation = (Point2D.Float)this.getLocation().clone();
        super.setLocation(location);
        this.resetContinueIconLocation(oldLocation, this.getLocation());
    }

    @Override
    public void setLocation(float x, float y) {
        Point2D.Float oldLocation = (Point2D.Float)this.getLocation().clone();
        super.setLocation(x, y);
        this.resetContinueIconLocation(oldLocation, this.getLocation());
    }
}

