/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.rpgui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kinugasa.game.GameLog;
import kinugasa.game.rpgui.ChipAttribute;
import kinugasa.resource.ContentsIOException;
import kinugasa.resource.DuplicateNameException;
import kinugasa.resource.Nameable;
import kinugasa.resource.Storage;
import kinugasa.resource.text.FileNotFoundException;
import kinugasa.resource.text.IllegalXMLFormatException;
import kinugasa.resource.text.XMLAttribute;
import kinugasa.resource.text.XMLElement;
import kinugasa.resource.text.XMLFile;
import kinugasa.resource.text.XMLFileSupport;
import kinugasa.util.StopWatch;

public final class ChipAttributeStorage
extends Storage<ChipAttribute>
implements Serializable,
XMLFileSupport {
    private static final long serialVersionUID = -3407377075571254018L;
    private static final ChipAttributeStorage INSTANCE = new ChipAttributeStorage();

    private ChipAttributeStorage() {
        this.putDefaultAttribute();
    }

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, FileNotFoundException, ContentsIOException, DuplicateNameException {
        StopWatch watch = new StopWatch().start();
        XMLFile reader = new XMLFile(filePath).load();
        XMLElement root = reader.getFirst();
        if (!"kinugasaChipAttribute".equals(root.getName())) {
            throw new IllegalXMLFormatException("illegal root node name : " + root);
        }
        List<XMLElement> attributeElements = root.getElement("attribute");
        int size = attributeElements.size();
        for (int i = 0; i < size; ++i) {
            this.add(new ChipAttribute(((XMLAttribute)attributeElements.get(i).getAttributes().get("name")).getValue()));
        }
        reader.dispose();
        watch.stop();
        GameLog.printInfo("\u30c1\u30c3\u30d7\u5c5e\u6027\u304c\u6b63\u5e38\u306b\u8aad\u307f\u8fbc\u307e\u308c\u307e\u3057\u305f(" + watch.getTime() + " ms) : size=[" + this.size() + "]");
        ArrayList list = new ArrayList(this.getAll());
        Collections.sort(list);
        int size2 = list.size();
        for (int i = 0; i < size2; ++i) {
            GameLog.printInfo("- " + ((ChipAttribute)list.get(i)).toString());
        }
    }

    private void putDefaultAttribute() {
        this.put(new ChipAttribute("VOID"));
        this.put(new ChipAttribute("CLOSE"));
    }

    @Override
    public Iterator<ChipAttribute> iterator() {
        return super.iterator();
    }

    public static ChipAttributeStorage getInstance() {
        return INSTANCE;
    }

    @Override
    public void remove(ChipAttribute val) {
        super.remove(val);
        this.putDefaultAttribute();
    }

    @Override
    public void remove(String key) {
        super.remove(key);
        this.putDefaultAttribute();
    }

    public void removeAll(ChipAttribute ... values) {
        super.removeAll((Nameable[])values);
        this.putDefaultAttribute();
    }

    @Override
    public void removeAll(Collection<? extends ChipAttribute> values) {
        super.removeAll(values);
        this.putDefaultAttribute();
    }

    @Override
    public void removeAll(String ... keys) {
        super.removeAll(keys);
        this.putDefaultAttribute();
    }

    @Override
    public void clear() {
        super.clear();
        this.putDefaultAttribute();
    }
}

