/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.event2;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kinugasa.game.event2.CreateEvent;
import kinugasa.game.event2.Event;
import kinugasa.graphics.ImageUtil;
import kinugasa.object.ImagePainter;
import kinugasa.object.ImagePainterStorage;
import kinugasa.object.ImageSprite;
import kinugasa.object.MovingModel;
import kinugasa.object.TVector;
import kinugasa.object.movemodel.AngleChange;
import kinugasa.resource.text.FileIOException;
import kinugasa.resource.text.FileNotFoundException;
import kinugasa.resource.text.IllegalXMLFormatException;
import kinugasa.resource.text.XMLAttribute;
import kinugasa.resource.text.XMLElement;
import kinugasa.resource.text.XMLFile;
import kinugasa.resource.text.XMLFileSupport;

public class EventManager
implements XMLFileSupport {
    private HashMap<Long, List<Event<?>>> events = new HashMap();

    @Override
    public void readFromXML(String filePath) throws IllegalXMLFormatException, FileNotFoundException, FileIOException {
        XMLFile file = new XMLFile(filePath);
        if (!file.getFile().exists()) {
            throw new FileNotFoundException(filePath + " is not found");
        }
        for (XMLElement e : file.load().getFirst().getElement("EVENT")) {
            long frame = Long.parseLong(((XMLAttribute)e.getAttributes().get("frame")).getValue());
            for (XMLElement c : e.getElement("CREATE")) {
                String type;
                switch (type = ((XMLAttribute)c.getAttributes().get("type")).getValue()) {
                    case "IMAGESPRITE": {
                        float x = ((XMLAttribute)c.getAttributes().get("x")).getFloatValue();
                        float y = ((XMLAttribute)c.getAttributes().get("y")).getFloatValue();
                        float w = ((XMLAttribute)c.getAttributes().get("w")).getFloatValue();
                        float h = ((XMLAttribute)c.getAttributes().get("h")).getFloatValue();
                        float dir = ((XMLAttribute)c.getAttributes().get("dir")).getFloatValue();
                        float spd = ((XMLAttribute)c.getAttributes().get("spd")).getFloatValue();
                        MovingModel mv = this.createMovingModel(c.getElement("MV").get(0));
                        ImagePainter ip = (ImagePainter)ImagePainterStorage.getInstance().get(((XMLAttribute)c.getAttributes().get("ip")).getValue());
                        BufferedImage image = ImageUtil.load(((XMLAttribute)c.getAttributes().get("image")).getValue());
                        if (!this.events.containsKey(frame)) {
                            this.events.put(frame, new ArrayList());
                        }
                        this.events.get(frame).add(new CreateEvent<ImageSprite>(frame, () -> new ImageSprite(x, y, w, h, new TVector(dir, spd), mv, image, ip)));
                    }
                }
            }
        }
        System.out.println("event list");
        ArrayList<Long> key = new ArrayList<Long>(this.events.keySet());
        Collections.sort(key);
        for (Long l : key) {
            System.out.println(l + ":" + this.events.get(l));
        }
    }

    public boolean hasEvent(long frame) {
        return this.events.containsKey(frame);
    }

    public List<Event<?>> getEvents(long frame) {
        return this.events.get(frame);
    }

    private MovingModel createMovingModel(XMLElement mv) {
        String type;
        switch (type = ((XMLAttribute)mv.getAttributes().get("type")).getValue()) {
            case "AngleChange": {
                float value = ((XMLAttribute)mv.getAttributes().get("value")).getFloatValue();
                return new AngleChange(value);
            }
        }
        throw new IllegalArgumentException("illegal type :" + type);
    }
}

