/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.game.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import kinugasa.game.GameLog;
import kinugasa.game.event.EventManager;
import kinugasa.game.event.TimeEvent;
import kinugasa.resource.NameNotFoundException;
import kinugasa.resource.NotYetLoadedException;

public abstract class MultiClassEventManager
extends EventManager {
    private static final long serialVersionUID = 5774295111597602465L;
    private List<TimeEvent<?>> events;

    public MultiClassEventManager() {
        this(32);
    }

    public MultiClassEventManager(int initialSize) {
        this.events = new ArrayList(initialSize);
    }

    @Override
    protected abstract void init();

    @Override
    public MultiClassEventManager load() {
        return (MultiClassEventManager)super.load();
    }

    @Override
    public MultiClassEventManager free() {
        return (MultiClassEventManager)super.free();
    }

    @Override
    public void printAll() {
        int size = this.events.size();
        for (int i = 0; i < size; ++i) {
            GameLog.printInfo("-" + this.events.get(i));
        }
    }

    @Override
    public void sort() {
        Collections.sort(this.events);
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public void clear() {
        this.events.clear();
    }

    @Override
    public boolean contains(TimeEvent<?> evt) {
        return this.events.contains(evt);
    }

    @Override
    public void remove(TimeEvent<?> evt) {
        this.events.remove(evt);
    }

    @Override
    public void removeAll(TimeEvent<?> ... evt) {
        this.events.removeAll(Arrays.asList(evt));
    }

    public final void add(TimeEvent<?> e) {
        this.events.add(e);
    }

    public final void addAll(TimeEvent<?> ... e) {
        this.events.addAll(Arrays.asList(e));
    }

    public final <T extends Serializable> TimeEvent<T> getNext(Class<T> type) throws NotYetLoadedException, NameNotFoundException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        int size = this.events.size();
        for (int i = 0; i < size; ++i) {
            if (!this.events.get(i).getType().equals(type) && !type.isInstance(this.events.get(i).getObject())) continue;
            return this.events.get(i);
        }
        throw new NameNotFoundException("not found : type=[" + type.getName() + "]");
    }

    public final <T> boolean hasNext(Class<T> type) throws NotYetLoadedException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        int size = this.events.size();
        for (int i = 0; i < size; ++i) {
            TimeEvent<?> evt = this.events.get(i);
            if (!evt.getType().equals(type) && !type.isInstance(evt.getObject()) || !evt.isReaching()) continue;
            return true;
        }
        return false;
    }

    public final <T extends Serializable> T execute(Class<T> type) throws NotYetLoadedException {
        if (!this.isLoaded()) {
            throw new NotYetLoadedException("not yet loaded : load=[" + this.isLoaded() + "]");
        }
        if (!this.hasNext(type)) {
            return null;
        }
        TimeEvent<T> evt = this.getNext(type);
        GameLog.printIfUsing(Level.INFO, "> MultiClassEventManager : execute : now=[" + this.getProgressTime() + "] event=[" + evt + "]");
        this.remove(evt);
        return (T)((Serializable)evt.execute());
    }

    public List<TimeEvent<?>> getEvents() {
        return this.events;
    }

    @Override
    public String toString() {
        return "> MultiClassEventManager{load=" + this.isLoaded() + ", events=" + this.size() + ", progressTime=" + this.getProgressTime() + "}";
    }
}

