/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.object;

import java.awt.geom.Point2D;
import kinugasa.util.MathUtil;

/**
 * xNgƊpx^xJvZ܂.
 * <br>
 *
 * <br>
 *
 * @version 4.20.0.<br>
 * @version 4.21.0-12/6/12_20:20.<br>
 * @version 4.26.0-12/7/07_17:27.<br>
 * @version 4.27.0-12/7/14_21:46.<br>
 * @version 4.27.5-12/7/19_15:51.<br>
 * @version 5.0.0 - 2013/01/14_16:23:07<br>
 * @author Dra0211<br>
 */
public class TVector implements  Cloneable {

	/** \萔ł. */
	public static final float EAST = 90f;
	/** 쓌\萔ł. */
	public static final float SOUTH_EAST = 135f;
	/** \萔ł. */
	public static final float SOUTH = 180f;
	/** 쐼\萔ł. */
	public static final float SOUTH_WEST = 225f;
	/** \萔ł. */
	public static final float WEST = 270f;
	/** k\萔ł. */
	public static final float NORTH_WEST = 315f;
	/** k\萔ł. */
	public static final float NORTH = 0f;
	/** k\萔ł. */
	public static final float NORTH_EAST = 45f;
	public float angle;
	public float speed;

	public TVector() {
		this(0, 0);
	}

	public TVector(float angle, float speed) {
		this.angle = angle;
		this.speed = speed;
	}

	public TVector(float speed) {
		this.angle = 0;
		this.speed = speed;
	}

	public TVector(Point2D.Float location) {
		this((float) (Math.toDegrees(Math.atan2(location.y, location.x))) + 90f,
				(float) Point2D.distance(0, 0, location.x, location.y));
	}

	public void clamp() {
		while (angle >= 360.0f) {
			angle -= 360.0f;
		}
		while (angle < 0.0f) {
			angle += 360.0f;
		}
	}

	public void add(TVector v) {
		setLocation(getX() + v.getX(), getY() + v.getY());
	}

	public static TVector add(TVector v1, TVector v2) {
		TVector result = new TVector();
		result.setLocation(v1.getX() + v2.getX(), v1.getY() + v2.getY());
		return result;
	}

	public void sub(TVector v) {
		setLocation(getX() - v.getX(), getY() - v.getY());
	}

	public static TVector sub(TVector v1, TVector v2) {
		TVector result = new TVector();
		result.setLocation(v1.getX() - v2.getX(), v1.getY() - v2.getY());
		return result;
	}

	public float getAngle() {
		return angle;
	}

	public float getAngleAsRad() {
		return (float) Math.toRadians(angle);
	}

	public float getSpeed() {
		return speed;
	}

	public void setAngle(float angle) {
		this.angle = angle;
	}

	public void setSpeed(float speed) {
		this.speed = speed;
	}

	public void setX(float x) {
		setLocation(x, getY());
	}

	public void setY(float y) {
		setLocation(getX(), y);
	}

	public float getX() {
		return speed * MathUtil.sin(angle);
	}

	//WnAY]瑬x-ɂ
	public float getY() {
		return -speed * MathUtil.cos(angle);
	}

	//̃\bh́AȈʒuԂBY𔽓]ق낤
	public Point2D.Float getLocation() {
		return new Point2D.Float(getX(), getY());
	}

	public Point2D.Float getLocationOnScreen() {
		Point2D.Float result = getLocation();
		result.y = -result.y;
		return result;
	}

	public void setLocation(float x, float y) {
		angle = (float) (Math.toDegrees(Math.atan2(y, x))) + 90f;
		speed = (float) Point2D.distance(0, 0, x, y);
	}

	@Override
	public TVector clone() {
		try {
			return (TVector) super.clone();
		} catch (CloneNotSupportedException ex) {
			throw new InternalError("clone failed");
		}
	}

	public boolean equalsInt(TVector obj) {
		return (int) obj.getAngle() == (int) getAngle()
				&& (int) obj.getSpeed() == (int) getSpeed();
	}

	public boolean equalsValue(TVector obj) {
		return obj.getSpeed() == getSpeed()
				&& obj.getAngle() == getAngle();
	}

	/**
	 * ̃CX^X̕\pxcenterDeg+-openDeg/2͈͓̔𒲂ׂ.
	 * 
	 * @param centerDeg X̒.<br>
	 * @param openDeg   z.<br>
	 *
	 * @return w肵͈͓ɂꍇtrueԂ.<br>
	 */
	public boolean checkRange(float centerDeg, float openDeg) {
		float ang = clamp(angle);
		float min = centerDeg - openDeg / 2;
		float max = centerDeg + openDeg / 2;
		return ang <= max && ang >= min;
	}

	/**
	 * ̃CX^X̕\pxcenterDeg+-openDeg/2͈͓̔𒲂ׂ.
	 * 
	 * @param centerDeg X̒.<br>
	 * @param openDeg   z.<br>
	 *
	 * @return w肵͈͓ɂꍇtrueԂ.<br>
	 */
	public boolean checkRange(TVector centerDeg, float openDeg) {
		return checkRange(centerDeg.getAngle(), openDeg);
	}

	@Override
	public String toString() {
		return "VectorF{" + "angle=" + angle + ", speed=" + speed + '}';
	}

	/**
	 * ̊px̃TC擾.
	 * 
	 * @return TC.<br>
	 */
	public float sin() {
		return MathUtil.sin(clamp(angle));
	}

	/**
	 * ̊px̃RTC擾.<br>
	 * 
	 * @return RTC.<br>
	 */
	public float cos() {
		return MathUtil.cos(clamp(angle));
	}

	/**
	 * ̊pxɊpxZ.<br>
	 * 
	 * @param a Zl.<br>
	 */
	public void addAngle(float a) {
		angle += a;
	}

	/**
	 * ̊pxɊpxZ.<br>
	 * 
	 * @param v Zpx.<br>
	 */
	public void addAngle(TVector v) {
		addAngle(v.angle);
	}

	/**
	 * ̊pxwidth/2̊px_ɕ␳.
	 * 
	 * @param width ␳px.<br>
	 */
	public void spreadAngle(float width) {
		angle -= width / 2;
		angle += (float) Math.random() * width;
	}

	/**
	 * ݒ.
	 * Wp1p2ւ̊pxݒ肵܂.<br>
	 * 
	 * @param p1 ݈ʒu.<br>
	 * @param p2 ړIn.<br>
	 */
	public void setAngle(Point2D.Float p1, Point2D.Float p2) {
		angle = (float) Math.toDegrees((Math.atan2(p2.y - p1.y, p2.x - p1.x))
				+ Math.toRadians(90));
	}

	/**
	 * x@̊px0x359x܂łɐ`܂.
	 * 
	 * @param deg x@̊px.<br>
	 *
	 * @return 0359xɐ`ꂽx@̊px.<br>
	 */
	public static float clamp(float deg) {
		while (deg >= 360.0f) {
			deg -= 360.0f;
		}
		while (deg < 0.0f) {
			deg += 360.0f;
		}
		return deg;
	}
}
