/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.object;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import kinugasa.game.GraphicsContext;
import kinugasa.resource.Nameable;

/**
 * Q[ɕ\鎩@LN^̊NXł.
 * <br>
 * XvCĝׂẴTuNXł́AN[K؂ɃI[o[ChKv܂B<br>
 * <br>
 *
 * @version 3.0 : 12/01/20_18:30-<br>
 * @version 4.0 : 12/02/06_21:00-<br>
 * @version 5.0 : 12/02/18_18:55-21:45<br>
 * @version 6.0.0 - 2012/06/02_16:46:58.<br>
 * @version 6.14.0 - 2012/06/12_20:17.<br>
 * @version 6.18.0 - 2012/06/16_02:26.<br>
 * @version 6.20.0 - 2012/06/18_21:53.<br>
 * @version 6.23.0 - 2012/07/01_00:48.<br>
 * @version 6.28.0 - 2012/07/07_00:37.<br>
 * @version 6.40.0 - 2012/07/07_17:24.<br>
 * @version 6.40.2 - 2012/07/07_22:45.<br>
 * @version 7.0.0 - 2012/07/14_16:41:11.<br>
 * @version 7.0.1 - 2012/07/21_23:42.<br>
 * @version 7.1.1 - 2012/09/23_01:58.<br>
 * @version 7.1.3 - 2012/11/12_00:54.<br>
 * @version 7.5.0 - 2012/11/21_11:39.<br>
 * @version 8.0.0 - 2013/01/14_16:52:02<br>
 * @version 8.3.0 - 2013/02/10_02:42<br>
 * @version 8.4.0 - 2013/04/28_21:54<br>
 * @version 8.5.0 - 2015/01/05_21:14<br>
 * @version 8.6.0 - 2015/03/29_16:26<br>
 * @author Dra0211<br>
 */
public abstract class Sprite
		implements Drawable, Shapeable, Cloneable, Comparable<Sprite>, Nameable {

	/**
	 * ̈.
	 */
	private Rectangle2D.Float bounds;
	/**
	 * SW̃LbV.
	 */
	private Point2D.Float center = null;
	/**
	 * ΒSW.
	 */
	private Point2D.Float personalCenter = null;
	/**
	 * Z[x.
	 */
	private float z = 0f;
	/**
	 * .
	 */
	private boolean visible = true;
	/**
	 * .
	 */
	private boolean exist = true;

	/**
	 * OiCӁj.
	 */
	private String name;

	/**
	 * SW̃LbV쐬܂.
	 */
	private void setCenter() {
		center = new Point2D.Float(bounds.x + bounds.width / 2,
				bounds.y + bounds.height / 2);
		personalCenter = new Point2D.Float(bounds.width / 2, bounds.height / 2);
	}

	/**
	 * SW̃LbVXV܂.
	 */
	protected final void updateCenter() {
		center.x = bounds.x + personalCenter.x;
		center.y = bounds.y + personalCenter.y;
	}

	/**
	 * SW̃LbVXV܂.
	 */
	protected final void updatePersonalCenter() {
		personalCenter.x = bounds.width / 2;
		personalCenter.y = bounds.height / 2;
	}

	/**
	 * VXvCg쐬܂. SẴtB[h܂.<br>
	 */
	public Sprite() {
		bounds = new Rectangle2D.Float();
		setCenter();
	}

	/**
	 * VXvCg쐬܂. ̃RXgN^ł́AfB[vRs[ɋ߂AQƂ𗘗pCX^X̍쐬sƂł܂.<br>
	 *
	 * @param bounds ̃XvCg̗̈.<br>
	 */
	private Sprite(Rectangle2D.Float bounds) {
		this.bounds = bounds;
		z = 0;
		setCenter();
	}

	/**
	 * ʒuуTCYw肵ăXvCg쐬܂.
	 *
	 * @param x XW.<br>
	 * @param y YW.<br>
	 * @param w .<br>
	 * @param h .<br>
	 */
	public Sprite(float x, float y, float w, float h) {
		this(x, y, w, h, 0);
	}

	/**
	 * ʒuуTCYw肵ăXvCg쐬܂.
	 *
	 * @param x XW.<br>
	 * @param y YW.<br>
	 * @param w .<br>
	 * @param h .<br>
	 * @param z
	 */
	public Sprite(float x, float y, float w, float h, float z) {
		this.bounds = new Rectangle2D.Float(x, y, w, h);
		this.z = z;
		setCenter();
	}

	/**
	 * XvCg`悵܂. visible܂existfalsêƂA`悵Ă͂Ȃ܂.<br>
	 *
	 * @param g OtBbNXReLXg.<br>
	 */
	@Override
	public abstract void draw(GraphicsContext g);

	/**
	 * XvCg̗lXȃvpeBXV܂. ̃\bh́AI[o[ChȂAs܂B<br>
	 * ړƂ͕ʂɁAԂXVKvꍇAI[o[Ch邱Ƃ `ł܂B<br>
	 */
	public void update() {
	}

	/**
	 * ̃XvCg̗̈擾܂. ̃\bhł̓N[Ԃ܂.<br>
	 *
	 * @return XvCg̗̈.<br>
	 */
	public Rectangle2D.Float getBounds() {
		return (Rectangle2D.Float) bounds.clone();
	}

	/**
	 * ̃XvCǵh蔻ḧ̗Ԃ܂. ̃\bh̓XvCg̃XvCgՓ˂Ă邩ꍇ
	 * XvCg܂`Ƙ_IȏՓˏԂʂ邽߂ɐ݂Ă܂B<br>
	 * ̃\bh̓ftHgł́AgetBounds()ƓlԂ܂B<br>
	 * ̃\bhgpꍇ͓K؂ɃI[o[ChĂB<br>
	 *
	 * @return XvCǵh蔻ḧ̗Ԃ܂BI[o[ChȂꍇgetBounds()Ԃ܂B<br>
	 */
	public Rectangle2D.Float getHitBounds() {
		return (Rectangle2D.Float) bounds.clone();
	}

	/**
	 * ̃XvCg̗̈ݒ肵܂.
	 *
	 * @param bounds XvCg̗̈.<br>
	 */
	public void setBounds(Rectangle2D.Float bounds) {
		this.bounds = bounds;
		updatePersonalCenter();
		updateCenter();
	}

	/**
	 * ̃XvCg̗̈ݒ肵܂.
	 *
	 * @param location ʒuw肵܂B<br>
	 * @param width łB<br>
	 * @param height łB<br>
	 */
	public void setBounds(Point2D.Float location, float width, float height) {
		setBounds(new Rectangle2D.Float(location.x, location.y, width, height));
	}

	/**
	 * ̃XvCg̗̈ݒ肵܂.
	 *
	 * @param x XʒułB<br>
	 * @param y YʒułB<br>
	 * @param width łB<br>
	 * @param height łB<br>
	 */
	public void setBounds(float x, float y, float width, float height) {
		setBounds(new Rectangle2D.Float(x, y, width, height));
	}

	//Kvł΁AhitBoundsɂ锻ɃI[o[Chł
	@Override
	public boolean contains(Point2D point) {
		return bounds.contains(point);
	}

	/**
	 * XvCg̍̈ʒu擾܂. ̃\bh͐VCX^XԂ܂.<br>
	 *
	 * @return ̈ʒu.<br>
	 */
	public Point2D.Float getLocation() {
		return new Point2D.Float(bounds.x, bounds.y);
	}

	/**
	 * XvCg̍̈ʒuݒ肵܂.
	 *
	 * @param location ̈ʒu.<br>
	 */
	public void setLocation(Point2D.Float location) {
		setLocation(location.x, location.y);
	}

	/**
	 * XvCg̍̈ʒuݒ肵܂.
	 *
	 * @param x XW.<br>
	 * @param y YW.<br>
	 */
	public void setLocation(float x, float y) {
		setX(x);
		setY(y);
	}

	/**
	 * XvCg̒S̍W擾܂. ̃\bhł̓N[Ԃ܂.<br>
	 *
	 * @return XvCg̒S̍W.EChEł̐΍W.<Br>
	 */
	public Point2D.Float getCenter() {
		return (Point2D.Float) center.clone();
	}

	/**
	 * XvCg̒SXW擾܂.
	 *
	 * @return XvCg̒SXWBEChEł̍WԂ܂B<br>
	 */
	public float getCenterX() {
		return center.x;
	}

	/**
	 * XvCg̒SYW擾܂.
	 *
	 * @return XvCg̒SYWBEChEł̍WԂ܂B<br>
	 */
	public float getCenterY() {
		return center.y;
	}

	/**
	 * XvCg̒S̑ΓIXW擾܂.
	 *
	 * @return XvCg̒SXWBXvCg̃TCYɑ΂钆S̍WԂ܂B<br>
	 */
	public float getPersonalCenterX() {
		return personalCenter.x;
	}

	/**
	 * XvCg̒S̑ΓIYW擾܂.
	 *
	 * @return XvCg̒SYWBXvCg̃TCYɑ΂钆S̍WԂ܂B<br>
	 */
	public float getPersonalCenterY() {
		return personalCenter.y;
	}

	/**
	 * XvCg̒S̑΍W擾܂. ΒSWƂ̓XvCg̗̈̍ォ̒S܂ł̋ł.<br>
	 * ̃\bhł̓N[Ԃ܂.<br>
	 *
	 * @return S̑΍W.<br>
	 */
	public Point2D.Float getPersonalCenter() {
		return (Point2D.Float) personalCenter.clone();
	}

	/**
	 * XvCg̃TCY擾܂. TCYintxɊۂ߂܂.<br>
	 * ̃\bh͐VCX^XԂ܂.<br>
	 *
	 * @return XvCg̃TCY.<br>
	 */
	public Dimension getSize() {
		return new Dimension((int) bounds.width, (int) bounds.height);
	}

	/**
	 * XvCg̃TCY擾܂. TCYintxɊۂ߂܂.<br>
	 *
	 * @param size XvCg̃TCY.<br>
	 */
	public void setSize(Dimension size) {
		setSize(size.width, size.height);
	}

	/**
	 * XvCg̃TCY擾܂.
	 *
	 * @param w XvCg̕.<br>
	 * @param h XvCg̍.<br>
	 */
	public void setSize(float w, float h) {
		bounds.width = w;
		bounds.height = h;
		updatePersonalCenter();
		updateCenter();
	}

	/**
	 * XvCg̐Ԃ擾܂.
	 *
	 * @return ̏ꍇtrueԂ.<Br>
	 */
	public boolean isExist() {
		return exist;
	}

	/**
	 * XvCg̐Ԃݒ肵܂.
	 *
	 * @param exist .<br>
	 */
	public void setExist(boolean exist) {
		this.exist = exist;
	}

	/**
	 * XvCg̉Ԃ擾܂.
	 *
	 * @return XvCg̉.<br>
	 */
	public boolean isVisible() {
		return visible;
	}

	/**
	 * XvCg̉Ԃݒ肵܂.
	 *
	 * @param visible XvCg̉.<br>
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}

	/**
	 * ̃XvCg̍XW擾܂.<br>
	 *
	 * @return XW.<br>
	 */
	public float getX() {
		return bounds.x;
	}

	/**
	 * ̃XvCg̍XWݒ肵܂.<br>
	 *
	 * @param x XW.<br>
	 */
	public void setX(float x) {
		bounds.x = x;
		center.x = bounds.x + personalCenter.x;
	}

	/**
	 * ̃XvCg̍YW擾܂.<br>
	 *
	 * @return YW.<br>
	 */
	public float getY() {
		return bounds.y;
	}

	/**
	 * ̃XvCg̍YWݒ肵܂.<br>
	 *
	 * @param y YW.<br>
	 */
	public void setY(float y) {
		bounds.y = y;
		center.y = bounds.y + personalCenter.y;
	}

	/**
	 * ̃XvCg̕擾܂.<br>
	 *
	 * @return .<br>
	 */
	public float getWidth() {
		return bounds.width;
	}

	/**
	 * ̃XvCg̕ݒ肵܂.<br>
	 *
	 * @param width .<br>
	 */
	public void setWidth(float width) {
		bounds.width = width;
		personalCenter.x = bounds.width / 2;
		center.x = bounds.x + personalCenter.x;
	}

	/**
	 * ̃XvCg̍擾܂.<br>
	 *
	 * @return .<br>
	 */
	public float getHeight() {
		return bounds.height;
	}

	/**
	 * ̃XvCg̍ݒ肵܂.<br>
	 *
	 * @param height .<br>
	 */
	public void setHeight(float height) {
		bounds.height = height;
		personalCenter.y = bounds.height / 2;
		center.y = bounds.y + personalCenter.y;
	}

	/**
	 * ̃XvCgZ[x擾܂.
	 *
	 * @return [x.<br>
	 */
	public float getZ() {
		return z;
	}

	/**
	 * ̃XvCgZ[xݒ肵܂.
	 *
	 * @param z [x.<br>
	 */
	public void setZ(float z) {
		this.z = z;
	}

	@Override
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	/**
	 * ̃XvCg̕쐬܂. ̃\bhł́ASẴtB[hN[jO܂.<br>
	 * ̃\bh̓TuNXœK؂ɃI[o[ChĂ.<br>
	 *
	 * @return ̃XvCgƓݒ̐VCX^X.<br>
	 */
	@Override
	public Sprite clone() {
		try {
			Sprite s = (Sprite) super.clone();
			s.bounds = (Rectangle2D.Float) this.bounds.clone();
			s.center = (Point2D.Float) this.center.clone();
			s.personalCenter = (Point2D.Float) this.personalCenter.clone();
			return s;
		} catch (CloneNotSupportedException ex) {
			Logger.getLogger(Sprite.class.getName()).log(Level.SEVERE, null, ex);
		}
		return null;
	}

	/**
	 * XvCg̐[xrAzW̏ɕёւ@\񋟂܂.
	 *
	 * @param spr rXvCg.<br>
	 *
	 * @return Comparable̎ɊÂl.<br>
	 */
	@Override
	public final int compareTo(Sprite spr) {
		return java.lang.Float.compare(z, spr.z);
	}

	@Override
	public String toString() {
		return "Sprite{" + "bounds=" + bounds + ", center=" + center + ", personalCenter="
				+ personalCenter + ", z=" + z + ", visible=" + visible + ", exist=" + exist + '}';
	}
}
