/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.object;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kinugasa.game.GraphicsContext;

/**
 * ̃XvCg܂Ƃ߂ĕ`悵A\[głNXł.
 * <br>
 * ̃NX̂Ƃ"XvCg"ƌĂт܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_20:45:45<br>
 * @author Dra0211<br>
 */
public class CompositeSprite extends BasicSprite {

	/** ̕XvCgXvCg̃Xgł. */
	private ArrayList<Sprite> sprites;

	/**
	 * VXvCg쐬܂.
	 * ̃RXgN^ł́AXvCgXg̏eʂ0ɂȂ܂B<br>
	 */
	public CompositeSprite() {
		this(Collections.<Sprite>emptyList());
	}

	/**
	 * VXvCg쐬܂.
	 *
	 * @param spr XvCgɒǉXvCgw肵܂B<br>
	 */
	public CompositeSprite(Sprite... spr) {
		this(Arrays.asList(spr));
	}

	/**
	 * VXvCg쐬܂.
	 *
	 * @param spr XvCgɒǉXvCgw肵܂B<br>
	 */
	public CompositeSprite(List<Sprite> spr) {
		this.sprites = new ArrayList<Sprite>(spr.size());
		addAll(spr.toArray(new Sprite[spr.size()]));
	}

	/**
	 * ̕XvCgɐVXvCgǉ܂.
	 * VXvCg̓XvCgXg̍Ōɒǉ܂B<br>
	 * ZW͎܂B<br>
	 *
	 * @param spr ǉXvCgw肵܂B<br>
	 *
	 * @throws IllegalArgumentException ǉXvCgthiŝƂA܂́AǉXvCgCompositeSprite
	 * ̕XvCgێXvCgXgthis܂͐ẽXvCgꍇɓ܂B<br>
	 * XvCg̐e̕XvCgׂĂ̎q̐eƏzQƂɂȂĂ邩̃`FbN
	 * VXvCgǉ邽тɍċAIɍs܂B<br>
	 */
	public void add(Sprite spr) throws IllegalArgumentException {
		if (spr instanceof CompositeSprite) {
			checkInstance(Arrays.asList(this), Arrays.asList(spr));
		}
		sprites.add(spr);
	}

	/**
	 * ̕XvCgɐVXvCgǉ܂.
	 * VXvCg̓XvCgXg̍ŌɎw肳ꂽŒǉ܂B<br>
	 * ZW͎܂B<br>
	 *
	 * @param spr ǉXvCgw肵܂B<br>
	 *
	 * @throws IllegalArgumentException ǉXvCgthis܂܂ƂA܂́AǉXvCgCompositeSprite
	 * ̕XvCgێXvCgXgthis܂͐ẽXvCgꍇɓ܂B<br>
	 * XvCg̐e̕XvCgׂĂ̎q̐eƏzQƂɂȂĂ邩̃`FbN
	 * VXvCgǉ邽тɍċAIɍs܂B<br>
	 */
	public void addAll(Sprite... spr) throws IllegalArgumentException {
		for (Sprite s : spr) {
			add(s);
		}
	}

	/**
	 * ̕XvCgɐVXvCgǉ܂.
	 * VXvCg̓XvCgXg̍ŌɎw肳ꂽŒǉ܂B<br>
	 * ZW͎܂B<br>
	 *
	 * @param spr ǉXvCgw肵܂B<br>
	 *
	 * @throws IllegalArgumentException ǉXvCgthis܂܂ƂA܂́AǉXvCgCompositeSprite
	 * ̕XvCgێXvCgXgthis܂͐ẽXvCgꍇɓ܂B<br>
	 * XvCg̐e̕XvCgׂĂ̎q̐eƏzQƂɂȂĂ邩̃`FbN
	 * VXvCgǉ邽тɍċAIɍs܂B<br>
	 */
	public void addAll(List<Sprite> spr) throws IllegalArgumentException {
		addAll(spr.toArray(new Sprite[spr.size()]));
	}

	/**
	 * w肵XvCgA̕XvCgɊ܂܂ĂꍇÃXvCg̕XvCg폜܂.
	 *
	 * @param spr 폜XvCgw肵܂B<br>
	 */
	public void remove(Sprite spr) {
		sprites.remove(spr);
	}

	/**
	 * w肵XvCgA̕XvCgɊ܂܂ĂꍇÃXvCg̕XvCg폜܂.
	 *
	 * @param spr 폜XvCgw肵܂B<br>
	 */
	public void removeAll(Sprite... spr) {
		sprites.removeAll(Arrays.asList(spr));
	}

	/**
	 * w肵XvCgA̕XvCgɊ܂܂ĂꍇÃXvCg̕XvCg폜܂.
	 *
	 * @param spr 폜XvCgw肵܂B<br>
	 */
	public void removeAll(List<Sprite> spr) {
		removeAll(spr.toArray(new Sprite[spr.size()]));
	}

	/**
	 * w肵XvCg̕XvCgɊ܂܂Ă邩܂.
	 *
	 * @param spr XvCgw肵܂B<br>
	 *
	 * @return spr̕XvCg̃XvCgXgɊ܂܂ĂꍇtrueAłȂꍇfalseԂ܂B<br>
	 */
	public boolean contains(Sprite spr) {
		return sprites.contains(spr);
	}
	/*
	 * TODO:ǉ郁\bh
	 * public boolean containsAll(Sprite... spr);
	 * public boolean containsAll(List<Sprite> spr);
	 * public boolean deepContains(Sprite spr );
	 * public boolean deepContainsAll(Sprite... spr);
	 * public boolean deepContainsAll(List<Sprite> spr);
	 */

	/**
	 * XvCgXĝׂẴXvCgȀZWɕׂ܂.
	 *
	 * @param minZ Xg0Ԗڂɐݒ肳zWw肵܂B<br>
	 * @param maxZ Xg̍Ō̗vfɐݒ肳zWw肵܂B<br>
	 *
	 * @throws IllegalArgumentException minZ &gt; maxẐƂɓ܂B<br>
	 */
	public void sortZ(float minZ, float maxZ) throws IllegalArgumentException {
		if (minZ > maxZ) {
			throw new IllegalArgumentException("min > max : minZ=[" + minZ + "] maxZ=[" + maxZ + "]");
		}
		float z = minZ;
		float addZ = (maxZ - minZ) / sprites.size();
		for (int i = 0; i < sprites.size(); i++) {
			sprites.get(i).setZ(z + addZ * i);
		}
		sort();
	}

	/**
	 * XvCgXĝׂẴXvCg폜܂.
	 */
	public void clear() {
		sprites.clear();
	}

	/**
	 * ̕XvCgXvCgXg擾܂.
	 * Xg͎QƂێ܂BXgɑ΂鑀͕XvCgɓKp܂B<br>
	 *
	 * @return ̕XvCg̃XvCgXgԂ܂B<br>
	 */
	public List<Sprite> getSprites() {
		return sprites;
	}

	/**
	 * XvCgXg̎w肵CfbNXɊi[ĂXvCg擾܂.
	 *
	 * @param idx 擾XvCg̃CfbNXw肵܂.<Br>
	 *
	 * @return w肵CfbNX̃XvCgԂ܂.<br>
	 *
	 * @throws IndexOutOfBoundsException sȃCfbNX̏ꍇɓ܂B<br>
	 */
	public Sprite getSprite(int idx) throws IndexOutOfBoundsException {
		return sprites.get(idx);
	}

	/**
	 * ̕XvCgXvCg̐擾܂.
	 *
	 * @return XvCgXg̗vfԂ܂B<br>
	 */
	public int size() {
		return sprites.size();
	}

	/**
	 * XvCgɒǉĂXvCg̈ˑ֌W𒲍܂.
	 *
	 * ̃\bh͍ċAIɌĂяo܂B<br>
	 *
	 * @param parents oꂽׂĂ̕XvCgi[Ă郊XgłB<br>
	 * ̃Xgɂthis܂݂܂B<br>
	 * @param sprites oꂽׂẴXvCgi[Ă郊XgłB<br>
	 * ̃Xgɂ͕XvCg܂܂Ă܂B<br>
	 *
	 * @throws IllegalArgumentException XvCg̈ˑ֌WɏzQƂꂽƂɓ܂B<br>
	 */
	private void checkInstance(List<CompositeSprite> parents, List<Sprite> sprites)
			throws IllegalArgumentException {
		Sprite spr;
		for (int i = 0, size = sprites.size(); i < size; i++) {
			spr = sprites.get(i);
			if (spr instanceof CompositeSprite) {
				CompositeSprite newParent = (CompositeSprite) spr;
				for (int j = 0, parentSize = parents.size(); j < parentSize; j++) {
					if (spr == parents.get(j)) {
						throw new IllegalArgumentException(
								"found loop reference : sprite=[" + spr + "]");
					}
				}
				List<CompositeSprite> newParents = new ArrayList<CompositeSprite>(parents);
				newParents.add(newParent);
				checkInstance(newParents, newParent.sprites);
			}
		}
	}

	/**
	 * ǉĂ邷ׂẴXvCg̏ŕ`悵܂.
	 * ̃\bhł́A̕XvCg̉ԂƐԂl܂B<br>
	 * eXvCǵAꂼ̉ԂƐԂэWgp܂B<br>
	 *
	 * @param g ރOtBbNXReLXg𑗐M܂B<br>
	 */
	@Override
	public void draw(GraphicsContext g) {
		if (!isVisible() || !isExist()) {
			return;
		}
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).draw(g);
		}
	}

	/**
	 * ǉĂ邷ׂẴXvCg\[gĂ`悵܂.
	 * ̃\bhł́A̕XvCg̉ԂƐԂl܂B<br>
	 * eXvCǵAꂼ̉ԂƐԂэWgp܂B<br>
	 * ̃\bhł́AXvCgXgɕXvCg݂ꍇ́A
	 * ̕XvCgċAIɃ\[g܂B<br>
	 *
	 * @param g ރOtBbNXReLXg𑗐M܂B<br>
	 * @param sortMode \[g@w肵܂BSpriteSortModewł܂B<br>
	 */
	public void draw(GraphicsContext g, Comparator<Sprite> sortMode) {
		sort(sortMode);
		draw(g);
	}

	/**
	 * XvCgXg\[g܂.
	 * ̃\bhł́AXvCgXgɕXvCg݂ꍇ́A
	 * ̕XvCgċAIɃ\[g܂B<br>
	 *
	 * @param sortMode \[g@w肵܂BSpriteSortModewł܂B<br>
	 */
	public void sort(Comparator<Sprite> sortMode) {
		deepSort(sprites, sortMode);
	}

	/**
	 * XvCgXg\[g܂.
	 * ̃\bhł́ASpriteSortModeBACK_TO_FRONTgp܂B<br>
	 * ̃\bhł́AXvCgXgɕXvCg݂ꍇ́A
	 * ̕XvCgċAIɃ\[g܂B<br>
	 */
	public void sort() {
		sort(SpriteSortMode.BACK_TO_FRONT);
	}

	/**
	 * XvCgXgċAIɃ\[g܂.
	 * ̃\bhł́AXvCgXgɕXvCg݂ꍇ́A
	 * ̕XvCgċAIɃ\[g܂B<br>
	 * ̃\bh͍ċAIɏ܂B<br>
	 *
	 * @param sprs \[gXvCgXgw肵܂B<br>
	 * @param sortMode \[g@w肵܂BSpriteSortModewł܂B<br>
	 */
	private void deepSort(List<Sprite> sprs, Comparator<Sprite> sortMode) {
		Sprite spr;
		for (int i = 0, size = sprs.size(); i < size; i++) {
			spr = sprs.get(i);
			if (spr instanceof CompositeSprite) {
				deepSort(((CompositeSprite) spr).sprites, sortMode);
			}
		}
		Collections.sort(sprs, sortMode);
	}

	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setVisible(visible);
		}
	}

	@Override
	public void setExist(boolean exist) {
		super.setExist(exist);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setExist(exist);
		}
	}

	//̕XvCĝZݒ肷
	@Override
	public void setZ(float z) {
		super.setZ(z);
	}

	/**
	 * XvCgXg̗vfidxԖڂ̃XvCgZWݒ肵܂.
	 *
	 * @param z ݒ肷Ww肵܂B<br>
	 * @param idx ZWݒ肷XvCg̃CfbNXw肵܂B<br>
	 *
	 * @throws IndexOutOfBoundsException sȃCfbNX̏ꍇɓ܂B<br>
	 */
	public void setZ(float z, int idx) throws IndexOutOfBoundsException {
		sprites.get(idx).setZ(z);
	}

	@Override
	public void setX(float x) {
		super.setX(x);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setX(x);
		}
	}

	@Override
	public void setY(float y) {
		super.setY(y);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setY(y);
		}
	}

	@Override
	public void setWidth(float width) {
		super.setWidth(width);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setWidth(width);
		}
	}

	@Override
	public void setHeight(float height) {
		super.setHeight(height);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setHeight(height);
		}
	}

	@Override
	public void setLocation(Point2D.Float location) {
		super.setLocation(location);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setLocation(location);
		}
	}

	@Override
	public void setLocation(float x, float y) {
		super.setLocation(x, y);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setLocation(x, y);
		}
	}

	@Override
	public void setSize(float w, float h) {
		super.setSize(w, h);
		for (int i = 0, size = sprites.size(); i < size; i++) {
			sprites.get(i).setSize(w, h);
		}
	}

	@Override
	public void setSize(Dimension size) {
		super.setSize(size);
		for (int i = 0, sprSize = sprites.size(); i < sprSize; i++) {
			sprites.get(i).setSize(size);
		}
	}

	@Override
	public void setBounds(Rectangle2D.Float bounds) {
		super.setBounds(bounds);
		for (int i = 0, sprSize = sprites.size(); i < sprSize; i++) {
			sprites.get(i).setBounds(bounds);
		}
	}

	@Override
	public void setAngle(float angle) {
		super.setAngle(angle);
		for (int i = 0, sprSize = sprites.size(); i < sprSize; i++) {
			if (sprites.get(i) instanceof BasicSprite) {
				((BasicSprite) sprites.get(i)).setAngle(angle);
			}
		}
	}

	@Override
	public void setMovingModel(MovingModel movingModel) {
		super.setMovingModel(movingModel);
		for (int i = 0, sprSize = sprites.size(); i < sprSize; i++) {
			if (sprites.get(i) instanceof BasicSprite) {
				((BasicSprite) sprites.get(i)).setMovingModel(movingModel);
			}
		}
	}

	@Override
	public void setVector(TVector vector) {
		super.setVector(vector);
		for (int i = 0, sprSize = sprites.size(); i < sprSize; i++) {
			if (sprites.get(i) instanceof BasicSprite) {
				((BasicSprite) sprites.get(i)).setVector(vector);
			}
		}
	}

	@Override
	public void setSpeed(float speed) {
		super.setSpeed(speed);
		for (int i = 0, sprSize = sprites.size(); i < sprSize; i++) {
			if (sprites.get(i) instanceof BasicSprite) {
				((BasicSprite) sprites.get(i)).setSpeed(speed);
			}
		}
	}

	/**
	 * XvCg̎ŃtB^OATuXg쐬܂.
	 * @param <T> XvCg̊gNXw肵܂B<br>
	 * @param type ^w肵܂B<br>
	 * @return w肵^̗vfVXgɊi[ĕԂ܂BԂ
	 * ̕XvCgɊi[ĂhꂽԁhłB<br>
	 */
	public <T extends Sprite> List<Sprite> subList(Class<T> type) {
		List<Sprite> result = new ArrayList<Sprite>();
		for (int i = 0, size = size(); i < size; i++) {
			Sprite sprite = getSprite(i);
			if (type.equals(sprite.getClass())) {
				result.add(getSprite(i));
			}
		}
		return result;
	}

	@Override
	@SuppressWarnings("unchecked")
	public CompositeSprite clone() {
		CompositeSprite sprite = (CompositeSprite) super.clone();
		sprite.sprites = (ArrayList<Sprite>) this.sprites.clone();
		return sprite;
	}

	@Override
	public String toString() {
		return "CompositeSprite{" + "sprites=" + sprites + '}';
	}
}
