/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.graphics;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kinugasa.game.GameLog;

/**
 * 1̉摜\[X؂oāẢ摜CX^X\z邽߂̃r_ł.
 * <br>
 * ̃ASYŕ̃XvCgV[g\zꍇSpriteSheetCuttergpĂB<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/13_13:00:09<br>
 * @version 1.1.0 - 2015/06/19_22:39<br>
 * @author Dra0211<br>
 */
public class SpriteSheet {

	/**
	 * 摜؂ox[XƂȂ摜ł. ̉摜͕ύX܂B
	 */
	private BufferedImage baseImage;
	/**
	 * ؂o摜ǉ郊Xgł.
	 */
	private ArrayList<BufferedImage> subImages;

	/**
	 * ̃XvCgV[g쐬܂.
	 */
	public SpriteSheet() {
		subImages = new ArrayList<BufferedImage>(32);
	}

	/**
	 * VXvCgV[g\z܂.
	 *
	 * @param filePath [h摜̃pXw肵܂B ̃RXgN^ł́AImageUtilload\bhgpĉ摜[h܂B<br>
	 */
	public SpriteSheet(String filePath) {
		baseImage = ImageUtil.load(filePath);
		subImages = new ArrayList<BufferedImage>(32);
	}

	/**
	 * VXvCgV[g\z܂.
	 *
	 * @param baseImage x[XƂȂ摜w肵܂B<br>
	 */
	public SpriteSheet(BufferedImage baseImage) {
		this.baseImage = baseImage;
		subImages = new ArrayList<BufferedImage>(32);
	}

	/**
	 * x[X摜̎w肳ꂽ̈؂oĐV摜Ƃ܂.
	 *
	 * @param x XW.<br>
	 * @param y YW.<br>
	 * @param width .<br>
	 * @param height .<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 *
	 * @throws RasterFormatException 摜͈̔͊OɃANZXƂɓ.<br>
	 */
	public SpriteSheet cut(int x, int y, int width, int height) throws RasterFormatException {
		subImages.add(baseImage.getSubimage(x, y, width, height));
		return this;
	}

	/**
	 * x[X摜̎w肳ꂽ̈؂oĐV摜Ƃ܂.
	 *
	 * @param rectangle ̈.<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 *
	 * @throws RasterFormatException 摜͈̔͊OɃANZXƂɓ.<br>
	 */
	public SpriteSheet cut(Rectangle rectangle) throws RasterFormatException {
		return cut(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
	}

	public SpriteSheet resizeAll(float scale) {
		BufferedImage[] result = ImageEditor.resizeAll(subImages.<BufferedImage>toArray(new BufferedImage[subImages.size()]), scale);
		subImages.clear();
		addAll(result);
		return this;
	}

	/**
	 * ؂oASYɊÂāÃV[g؂o܂.
	 *
	 * @param cutter ̐؂oݒASY.<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 *
	 * @throws RasterFormatException 摜͈̔͊OɃANZXƂɓ.<br>
	 */
	public SpriteSheet cut(SpriteSheetCutter cutter) throws RasterFormatException {
		addAll(cutter.cut(baseImage));
		return this;
	}

	/**
	 * W0,0width,height̃TCYœ񎟌ɉ\ȐASĂ̕摜Xgɒǉ܂.
	 *
	 * <br>
	 *
	 * @param width .<br>
	 * @param height .<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 *
	 * @throws RasterFormatException 摜͈̔͊OɃANZXƂɓ.<br>
	 */
	public SpriteSheet split(int width, int height) throws RasterFormatException {
		BufferedImage[][] images = ImageUtil.splitAsArray(baseImage, width, height);
		for (BufferedImage[] line : images) {
			subImages.addAll(Arrays.asList(line));
		}
		return this;
	}

	/**
	 * W0,ywidth,height̃TCYXɉ\Ȑ摜𕪊ASĂ̕摜Xgɒǉ܂.
	 *
	 * @param y YW.<br>
	 * @param width .<br>
	 * @param height .<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 *
	 * @throws RasterFormatException 摜͈̔͊OɃANZXƂɓ.<br>
	 */
	public SpriteSheet rows(int y, int width, int height) throws RasterFormatException {
		subImages.addAll(Arrays.asList(ImageUtil.rows(baseImage, y, width, height)));
		return this;
	}

	/**
	 * Wx,0width,height̃TCYYɉ\Ȑ摜𕪊ASĂ̕摜Xgɒǉ܂.
	 *
	 * @param x XW.<br>
	 * @param width .<br>
	 * @param height .<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 *
	 * @throws RasterFormatException 摜͈̔͊OɃANZXƂɓ.<br>
	 */
	public SpriteSheet columns(int x, int width, int height) throws RasterFormatException {
		subImages.addAll(Arrays.asList(ImageUtil.columns(baseImage, x, width, height)));
		return this;
	}

	/**
	 * w肳ꂽ摜ǉ܂.
	 *
	 * @param image 摜.<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 */
	public SpriteSheet add(BufferedImage image) {
		subImages.add(image);
		return this;
	}

	/**
	 * w肳ꂽ0ȏ̉摜SĂ̏ŃXgɒǉ܂.
	 *
	 * @param images 摜.<br>
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 */
	public SpriteSheet addAll(BufferedImage... images) {
		subImages.addAll(Arrays.asList(images));
		return this;
	}

	/**
	 * x[X摜{̂Xgɒǉ܂.
	 *
	 * @return ̃CX^X̂Ԃ.<br>
	 */
	public SpriteSheet baseImage() {
		subImages.add(baseImage);
		return this;
	}

	/**
	 * m肵AǉĂSẲ摜ǉꂽ̔zƂĎ擾܂. ̑ł́AnullCX^XsubImage͐؂̂Ă܂B<br>
	 *
	 * @return ǉĂ摜̔z.<br>
	 */
	public BufferedImage[] images() {
		GameLog.printInfo("SpriteSheet؂o܂ : size=[" + subImages.size() + "]");
		subImages.trimToSize();
		int nullIdx = 0;
		for (int size = subImages.size(); nullIdx < size && subImages.get(nullIdx) != null; nullIdx++);
		BufferedImage[] result = new BufferedImage[nullIdx];
		System.arraycopy(subImages.<BufferedImage>toArray(new BufferedImage[subImages.size()]), 0, result, 0, nullIdx);

		return result;
	}

	/**
	 * m肵AǉĂSẲ摜ǉꂽ̘AԂL[Ƃ}bvƂĎ擾܂.
	 *
	 * @return ǉĂ摜̃}bvB<br>
	 */
	public Map<String, BufferedImage> toMap() {
		Map<String, BufferedImage> result = new HashMap<String, BufferedImage>(subImages.size());
		for (int i = 0, size = subImages.size(); i < size; i++) {
			result.put(Integer.toString(i), subImages.get(i));
		}
		return result;
	}

	@Override
	public String toString() {
		return "SpriteSheet{" + "baseImage=" + baseImage + ", subImages=" + subImages + '}';
	}
}
