/*
 * The MIT License
 *
 * Copyright 2013 Dra0211.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package kinugasa.game.input;

import java.awt.Point;
import java.awt.Shape;

/**
 * }EXɂ͏Ԃi[܂.
 * <br>
 * AnyInput胁\bhł́A}EXJ[\̈ʒu0,0łȂꍇ ͂Ɣ肳܂B<br>
 * <br>
 *
 * @version 1.0.0 - 2013/01/14_14:08:38<br>
 * @author Dra0211<br>
 */
public final class MouseState extends InputDeviceState {

	private static final long serialVersionUID = -7984070482396918667L;

	/**
	 * }EX̏Ԃ쐬܂.
	 *
	 * @param LEFT_BUTTON {^̓͏ԂłB<br>
	 * @param RIGHT_BUTTON E{^̓͏ԂłB<br>
	 * @param WHEEL_BUTTON zC[{^̓͏ԂłB<br>
	 * @param IN_WINDOW EChËɂꍇtrue𑗐M܂B<br>
	 * @param DRAG_NOW hbȌꍇtrue𑗐M܂B<br>
	 * @param WHEEL_VALUE Oɓ͂ꂽzC[̉]ʂłB<br>
	 * @param location EChẼJ[\̈ʒułB<br>
	 * @param locationOnScreen B<br>
	 */
	MouseState(
			boolean LEFT_BUTTON,
			boolean RIGHT_BUTTON,
			boolean WHEEL_BUTTON,
			boolean IN_WINDOW,
			boolean DRAG_NOW,
			int WHEEL_VALUE,
			Point location,
			Point locationOnScreen,
			Point draggedLocation) {
		this.LEFT_BUTTON = LEFT_BUTTON;
		this.RIGHT_BUTTON = RIGHT_BUTTON;
		this.WHEEL_BUTTON = WHEEL_BUTTON;
		this.IN_WINDOW = IN_WINDOW;
		this.DRAG_NOW = DRAG_NOW;
		this.WHEEL_VALUE = WHEEL_VALUE;
		this.location = (Point) location.clone();
		this.locationOnScreen = (Point) locationOnScreen.clone();
		this.draggedLocation = draggedLocation;

	}
	/**
	 * {^̓͏Ԃł.
	 */
	public final boolean LEFT_BUTTON;
	/**
	 * E{^̓͏Ԃł.
	 */
	public final boolean RIGHT_BUTTON;
	/**
	 * zC[{^̓͏Ԃł.
	 */
	public final boolean WHEEL_BUTTON;
	/**
	 * EChËɂꍇtrue𑗐M܂.
	 */
	public final boolean IN_WINDOW;
	/**
	 * hbȌꍇtrue𑗐M܂.
	 */
	public final boolean DRAG_NOW;
	/**
	 * Oɓ͂ꂽzC[̉]ʂł.
	 */
	public final int WHEEL_VALUE;
	/**
	 * EChẼJ[\̈ʒuł.
	 */
	private Point location;
	/**
	 * XN[̃J[\̈ʒuł.
	 */
	private Point locationOnScreen;
	/**
	 * 0,0\Wł.
	 */
	private static final Point ZERO_POINT = new Point(0, 0);
	private Point draggedLocation;

	@Override
	public boolean isAnyInput() {
		return !location.equals(ZERO_POINT)
				|| !locationOnScreen.equals(ZERO_POINT)
				|| LEFT_BUTTON
				|| RIGHT_BUTTON
				|| WHEEL_BUTTON
				|| WHEEL_VALUE != 0
				|| DRAG_NOW;
	}

	@Override
	public boolean isAnyButtonInput() {
		return LEFT_BUTTON || RIGHT_BUTTON || WHEEL_BUTTON;
	}

	@Override
	public boolean isEmptyInput() {
		return location.equals(ZERO_POINT)
				&& locationOnScreen.equals(ZERO_POINT)
				&& !LEFT_BUTTON
				&& !RIGHT_BUTTON
				&& !WHEEL_BUTTON
				&& WHEEL_VALUE == 0
				&& !DRAG_NOW;
	}

	/**
	 * }EX̃EChËʒu擾܂.
	 * ̍W̓^Cgo[܂߂WƂȂ܂̂ŁAۂɂ͂̕␳KvłB<br>
	 * ␳́AGame.gerWindows܂B<br>
	 *
	 * @return EChËʒũN[łB<br>
	 */
	public Point getLocation() {
		return (Point) location.clone();
	}

	/**
	 * EChE̍W擾܂.
	 *
	 * @return EChËʒuXʒuԂ܂B
	 */
	public int getX() {
		return location.x;
	}

	/**
	 * EChE̍W擾܂.
	 *
	 * @return EChËʒuYuԂ܂B
	 */
	public int getY() {
		return location.y;
	}

	/**
	 * }EX̃XN[̈ʒu擾܂.
	 *
	 * @return XN[̈ʒũN[łB<br>
	 */
	public Point getLocationOnScreen() {
		return (Point) locationOnScreen.clone();
	}

	/**
	 * XN[̈ʒu擾܂.
	 *
	 * @return XN[̍ォXʒuԂ܂B
	 */
	public int getXOnScreen() {
		return locationOnScreen.x;
	}

	/**
	 * XN[̈ʒu擾܂.
	 *
	 * @return XN[̍ォYʒuԂ܂B
	 */
	public int getYOnScreen() {
		return locationOnScreen.y;
	}

	/**
	 * EChẼ}EẌʒuAshapeɂ邩𒲂ׂ܂.
	 *
	 * @param shape 肷̈𑗐M܂B<br>
	 * @return EChẼJ[\ʒushapeɂꍇtrueԂ܂B<br>
	 */
	public boolean contains(Shape shape) {
		return shape == null ? false : LEFT_BUTTON & shape.contains(location);
	}

	/**
	 * }EX{^Ă邩܂.
	 *
	 * @param button {^w肵܂B<br>
	 * @return w肳ꂽ{^ĂꍇtrueԂ܂B<br>
	 */
	public boolean isPressed(MouseButtons button) {
		switch (button) {
			case LEFT_BUTTON: {
				return LEFT_BUTTON;
			}
			case RIGHT_BUTTON: {
				return RIGHT_BUTTON;
			}
			case WHEEL_BUTTON: {
				return WHEEL_BUTTON;
			}
			default:
				throw new AssertionError();
		}
	}

	public Point getDraggedLocation() {
		return (Point) draggedLocation.clone();
	}

	@Override
	public String toString() {
		return "MouseState{" + "LEFT_BUTTON=" + LEFT_BUTTON + ", RIGHT_BUTTON=" + RIGHT_BUTTON
				+ ", WHEEL_BUTTON=" + WHEEL_BUTTON + ", IN_WINDOW=" + IN_WINDOW + ", DRAG_NOW="
				+ DRAG_NOW + ", WHEEL_VALUE=" + WHEEL_VALUE + ", location=["
				+ location.x + ", " + location.y + "], locationOnScreen=["
				+ locationOnScreen.x + ", " + locationOnScreen.y + "]}";
	}

	@Override
	public MouseState clone() {
		MouseState result = (MouseState) super.clone();
		result.location = (Point) this.location.clone();
		result.locationOnScreen = (Point) this.locationOnScreen.clone();
		return result;
	}
}
