/*
 * Decompiled with CFR 0.152.
 */
package kinugasa.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import kinugasa.util.TimeCounter;

public final class BufferedList<T>
implements List<T>,
Cloneable,
Serializable,
RandomAccess {
    private static final long serialVersionUID = -8845399102208579167L;
    private ArrayList<T> list;
    private ArrayList<Object> removeList;
    private TimeCounter delayTime;

    public BufferedList() {
        this(512, TimeCounter.TRUE);
    }

    public BufferedList(int initialSize) {
        this(initialSize, TimeCounter.TRUE);
    }

    public BufferedList(int initialSize, TimeCounter delayTimeCounter) {
        this.list = new ArrayList(initialSize);
        this.removeList = new ArrayList(initialSize);
        this.delayTime = delayTimeCounter;
    }

    public BufferedList<T> clone() {
        try {
            BufferedList result = (BufferedList)super.clone();
            result.list = (ArrayList)this.list.clone();
            result.removeList = (ArrayList)this.removeList.clone();
            result.delayTime = this.delayTime.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("clone failed");
        }
    }

    public void addAll(T ... obj) {
        this.addAll((Collection<? extends T>)Arrays.asList(obj));
    }

    public void remove(T ... obj) {
        this.remove((Collection<? extends T>)Arrays.asList(obj));
    }

    public void remove(Collection<? extends T> obj) {
        this.removeList.addAll(obj);
    }

    public void remove() {
        this.list.removeAll(this.removeList);
        this.removeList.clear();
    }

    public void commit() {
        if (this.delayTime.isReaching()) {
            this.remove();
        }
    }

    public ArrayList<T> getList() {
        return this.list;
    }

    public void setList(ArrayList<T> list) {
        this.list = list;
    }

    public int listSize() {
        return this.list.size();
    }

    public ArrayList<Object> getRemoveList() {
        return this.removeList;
    }

    public void setRemoveList(ArrayList<Object> removeList) {
        this.removeList = removeList;
    }

    public int removeListSize() {
        return this.removeList.size();
    }

    public TimeCounter getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(TimeCounter delayTime) {
        this.delayTime = delayTime;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.list.toArray(ts);
    }

    @Override
    public boolean add(T e) {
        this.list.add(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int removeListSize = this.removeListSize();
        this.removeList.add(o);
        return removeListSize != this.removeList.size();
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        return this.list.containsAll(clctn);
    }

    @Override
    public boolean addAll(Collection<? extends T> clctn) {
        return this.list.addAll(clctn);
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> clctn) {
        return this.list.addAll(i, clctn);
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        int removeListSize = this.removeListSize();
        this.removeList.addAll(clctn);
        return removeListSize != this.removeList.size();
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        int removeListSize = this.removeListSize();
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            if (clctn.contains(this.get(i))) continue;
            this.remove((Object)this.get(i));
        }
        return removeListSize != this.removeList.size();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public void clearAll() {
        this.list.clear();
        this.removeList.clear();
    }

    @Override
    public T get(int i) {
        return this.list.get(i);
    }

    @Override
    public T set(int i, T e) {
        return this.list.set(i, e);
    }

    @Override
    public void add(int i, T e) {
        this.list.add(i, e);
    }

    @Override
    public T remove(int i) {
        return this.list.remove(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return this.list.listIterator(i);
    }

    @Override
    public List<T> subList(int i, int i1) {
        return this.list.subList(i, i1);
    }

    public String toString() {
        return "BufferedList{list=" + this.list + ", removeList=" + this.removeList + ", delayTime=" + this.delayTime + "}";
    }
}

